var calendar = null;

function init_my_shifts_tile() {
    if (incoming_shifts.length === 0) {
        $("#home_tile_my_services #home_incoming_services").text("Aucun service à venir...");
    } else {
        
        if (partner_data.comite === "True") {
            let message = $('#comite_my_shifs_message').clone()
            message.find('[data-type="nb_of_shifs_state"] [data-type="shifts_nb"]').text(partner_data.final_ftop_point)
            if (Math.abs(partner_data.final_ftop_point) > 1) {
                message.find('[data-type="nb_of_shifs_state"] [data-type="service_txt"]').text("services")
            }
            // let's get next ftop shift (incoming_shifts is ordered)
            if (incoming_shifts.length > 0) {
                const next_shift = incoming_shifts[0]
                let ns_date = new Date(next_shift.date_begin)
                const date_options = {dateStyle: "short"}
                message.find('[data-type="next_ftop_shift_date"]').text(ns_date.toLocaleDateString('fr-FR', date_options))
            }
            
            $("#home_tile_my_services .tile_content").html(message)
        } else {
            $("#home_tile_my_services #home_incoming_services").empty();
            let cpt = 0;

            for (shift of incoming_shifts) {
                if (cpt === 3) {
                    break;
                } else {
                    let shift_line_template = prepare_shift_line_template(shift.date_begin);

                    $("#home_tile_my_services #home_incoming_services").append(shift_line_template.html());

                    cpt++;
                }
            }
        }
    }
}

function process_asked_shift_template_change(shift_t_id) {
    var s_data = shift_templates[shift_t_id].data;
    var shift_name = get_shift_name(s_data);
    let msg = 'Inscription au créneau ' + shift_name;

    openModal(
        msg,
        function() {
            setTimeout(openModal, 300); // to show something happened , work in process
            let data = {
                partner_id: parseInt(partner_data.partner_id, 10),
                shift_type: 1, //force to standard
                shift_template_id: shift_t_id,
                unsubscribe_first: true
            };

            $.ajax({
                type: 'POST',
                url: '/members/shift_subscription',
                data: JSON.stringify(data),
                dataType:"json",
                traditional: true,
                contentType: "application/json; charset=utf-8",
                success: function(data) {
                    stdata = data.shift_template;
                    partner_data.regular_shift_name = stdata.name;
                    partner_data.shift_type = "standard";
                    init_my_info_data();
                    location.reload();
                },
                error: function(err_data) {
                    if (
                        err_data.status == 409
                        && typeof (err_data.responseJSON) != "undefined"
                    ) {
                        let modal_template = $("#modal_generic_error_change_shift_template");
                        modal_template.find(".modal_generic_error_change_shift_template_text").text(
                                err_data.responseJSON.message
                        );
                        closeModal();
                        openModal(
                            modal_template.html(),
                            () => {},
                            "Compris !",
                            true,
                            false
                        );
                    } else {
                        err = {
                            msg: "erreur serveur lors de l'inscription du membre au créneau",
                            ctx: 'members_space.shift_subscrition'
                        };
                        report_JS_error(err, 'members_space');
                        closeModal();

                        $.notify("Une erreur est survenue lors de l'inscription au créneau.", {
                            globalPosition:"top right",
                            className: "error"
                        });
                    }
                }
            });

        },
        'Valider',
        true, // modal closes after validation
        true,
        edit_shift_template_registration // on cancel , reload calendar
    );
}

function edit_shift_template_registration() {
    const calendar_params = {external: true, without_modal: true, shift_listener: true};
    if (calendar == null) calendar = $('#modal-calendar-choice').clone();
    if ($('#modal-calendar-choice').html().length > 0) {
        $('#modal-calendar-choice').empty();

    }
    calendar.find('.oddeven_selector').empty();
    displayMsg(calendar.html());
    $('#week_types').find('input')
        .change(() => {
            filter_weeks(calendar_params);
        });
    retrieve_and_draw_shift_tempates(calendar_params);


}

function init_home() {
    $("#go_to_shifts_calendar").on("click", () => {
        goto('echange-de-services');
    });
    $("#home_go_to_shift_history").on("click", () => {
        goto('mes-services');
    });
    $("#see_more_info_link").on('click', (e) => {
        e.preventDefault();
        goto('mes-infos');
    });
    // $("#go_to_forms").prop("href", "forms_link");
    $("#go_to_forms").on('click', (e) => {
        e.preventDefault();
        goto('faq');
    });

    $(".member_shift_name_area").on("click", ".fa-edit", (e) => {
        $('#week_types').find('input')
            .change(filter_weeks);
        e.preventDefault();
        edit_shift_template_registration();
    });

    if (partner_data.is_in_association === false) {
        $("#home .member_associated_partner_area").hide();
    } else {
        if (partner_data.is_associated_people === "True") {
            $(".member_associated_partner").text(partner_data.parent_name);
        } else if (partner_data.associated_partner_id !== "False") {
            $(".member_associated_partner").text(partner_data.associated_partner_name);
        }
    }

    // TODO vérif tile my info avec données binomes + rattrapage et délai

    // Init my info tile
    init_my_info_data();

    if (incoming_shifts !== null) {
        init_my_shifts_tile();
    } else {
        load_partner_shifts(partner_data.concerned_partner_id)
            .then(init_my_shifts_tile);
    }
    
    display_messages_for_service_exchange_24h_before();
}