#! /bin/bash

# Récupère le dossier contenant ce script
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

source "$SCRIPT_DIR/vars"

log_dir=~/cronlogs/shifts
mkdir -p "$log_dir"  # Crée le dossier s'il n'existe pas

MAXFILES=2920 # 1 year (8 times a day)
curl -o ${log_dir}/$(date +%F_%T)_absences.log http://$ip:$dj_port/members/record_absences

ls -t ${log_dir}/*_absences.log | sed 1,$MAXFILES\d | while read file ; do rm "$file"; done
