<?php

namespace App\Form\Type;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\DependencyInjection\ContainerInterface;
use App\Entity\Adherent;
use App\Entity\GlobalParameter;

class EncaissementFormType extends AbstractType
{
    protected $em;
    protected $security;
    protected $container;

    public function __construct(
        EntityManagerInterface $em,
        Security $security,
        ContainerInterface $container
    ) {
        $this->em = $em;
        $this->security = $security;
        $this->container = $container;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $mlcName = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::MLC_NAME_SMALL);
        $builder
            ->add('adherent', EntityType::class, [
                'class' => Adherent::class,
                'choices' => $this->em->getRepository(Adherent::class)->findOrderByName(),
                'attr' => [
                    'class' => 'form-control select2',
                ],
                'placeholder' => 'Choisissez un.e adhérent.e',
                'required' => true,
                'label' => 'Habitant•e : ',
                'choice_label' => 'name'
            ])
            ->add('montant', NumberType::class, [
                'label' => "Montant à payer en {$mlcName} : ",
                'required' => true,
                'attr' => ['autocomplete' => 'off']
            ])
            ->add('payment_code', HiddenType::class, [
                'label' => 'Code de validation de l\'habitant·e : ',
                'required' => false,
                'attr' => ['autocomplete' => 'off']
            ])
            ->add('save', SubmitType::class, ['label' => 'Valider'])
        ;

        if ($this->container->getParameter('presta_self_init_and_eval')) {
            $builder
                ->add('montantPanier', NumberType::class, [
                    'label' => 'Montant total du panier : ',
                    'required' => true,
                    'attr' => ['autocomplete' => 'off'],
                    'mapped' => false,
                    'help' => ''
                ])
            ;
        }


    }

    public function getBlockPrefix()
    {
        return 'formEncaissement';
    }
}
