<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use App\Entity\SelfEvalPrestaQuiz;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class DistributorSelfEvalPrestaQuizType extends SelfEvalPrestaQuizType
{
    public function __construct(Security $security, array $options = [])
    {
        parent::__construct($security, $options);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        /* PARTIE 3 : TRANSPARENCE ET JUSTE REMUNERATION */
        $this->opts['label'] = "Juste rémunération : les prix d'achats aux producteurs correspondent-ils au coût de la production (y compris la rémunération) ?";
        $this->opts['choices'] = [
            $this->frown . " pas connaissance du coût de production des produits achetés" => 0,
            $this->meh . " ne correspondent pas toujours mais connaissance du coût de production" => 1,
            $this->smile . " oui" => 2,
        ];
        $builder->add('transpar_jusrem', ChoiceType::class, $this->opts);
        $builder->add('transpar_jusrem_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Transparence : les consommateurs peuvent-ils accéder à des informations leur permettant de comprendre
            comment les prix des produits sont construits ?";
        $this->opts['choices'] = [
            $this->frown . " aucun moyen d'avoir accès aux informations" => 0,
            $this->meh . " au moins via l'équipe en discutant" => 1,
            $this->smile . " affichages et en discutant" => 2,
        ];
        $builder->add('transpar_transp', ChoiceType::class, $this->opts);
        $builder->add('transpar_transp_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Relation au producteur : sur l'offre alimentaire globale, quels sont les circuits de commercialisation majoritaires ?";
        $this->opts['choices'] = [
            $this->frown . " plus de 2 intermédiaires connus ou intraçable" => 0,
            $this->meh . " 2 intermédiaires connus" => 1,
            $this->smile . " 0 ou 1 intermédiaire connu" => 2,
        ];
        $builder->add('transpar_relpro', ChoiceType::class, $this->opts);
        $builder->add('transpar_relpro_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Transparence et juste rémunération : " . $this->labelEvalGlob;
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('transpar_global', ChoiceType::class, $this->opts);
        $builder->add('transpar_global_comment', TextareaType::class, $this->globalCmtOpts);

        /* PARTIE 4 : PRATIQUES AGRICOLES DURABLES */
        $this->opts['label'] = "Détenez-vous des labels ou des certifications (AB, Bio, Nature et Progrès, système de garantie
            participatif ou équivalent minimum ?";
        $this->opts['choices'] = [
            $this->frown . " moins de 50 % des produits" => 0,
            $this->meh . " entre 50 et 70% des produits" => 1,
            $this->smile . " plus de 70 % des produits" => 2,
        ];
        $builder->add('disagdur_labels', ChoiceType::class, $this->opts);
        $builder->add('disagdur_labels_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Le point de vente s'assure-t-il que ses produits alimentaires non labellisés mais conventionnables sont issus
            de pratiques agricoles durables ?";
        $this->opts['choices'] = [
            $this->frown . " non" => 0,
            $this->meh . " oui par des échanges avec le producteur ou le revendeur qui connaît les pratiques agricoles du secteur" => 1,
            $this->smile . " oui" => 2,
        ];
        $builder->add('disagdur_condur', ChoiceType::class, $this->opts);
        $builder->add('disagdur_condur_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Pratiques agricoles durables : " . $this->labelEvalGlob;
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('disagdur_global', ChoiceType::class, $this->opts);
        $builder->add('disagdur_global_comment', TextareaType::class, $this->globalCmtOpts);

        /* PARTIE 5 : LOCALITE DES PRODUITS */
        $this->opts['label'] = "Quelle est la provenance de l'offre alimentaire globale en produits bruts ?";
        $this->opts['choices'] = [
            $this->frown . " 0 à 49 % de produits locaux (moins de 250 km à la ronde)" => 0,
            $this->meh . " 50 à 79 % de produits locaux (moins de 250 km à la ronde)" => 1,
            $this->smile . " plus de 80 % de produits locaux (moins de 250 km à la ronde)" => 2,
        ];
        $builder->add('localite_probru', ChoiceType::class, $this->opts);
        $builder->add('localite_probru_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Quelle est la provenance de l'offre alimentaire globale en produits transformés ?";
        $this->opts['choices'] = [
            $this->frown . " 0 à 24 % de produits locaux (moins de 250 km à la ronde)" => 0,
            $this->meh . " 25 à 49 % de produits locaux (moins de 250 km à la ronde)" => 1,
            $this->smile . " plus de 50 % de produits locaux (moins de 250 km à la ronde)" => 2,
        ];
        $builder->add('localite_protra', ChoiceType::class, $this->opts);
        $builder->add('localite_protra_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Localité des produits : " . $this->labelEvalGlob;
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('localite_global', ChoiceType::class, $this->opts);
        $builder->add('localite_global_comment', TextareaType::class, $this->globalCmtOpts);

        //Review
        if($options['mode'] !== self::PRESTA_EDIT) {
            $this->reviewOpts['label'] = "Transparence et juste rémunération : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_transpar_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_transpar_global_comment', TextareaType::class, $this->reviewCmtOpts);

            $this->reviewOpts['label'] = "Pratiques agricoles durables : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_disagdur_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_disagdur_global_comment', TextareaType::class, $this->reviewCmtOpts);

            $this->reviewOpts['label'] = "Localité des produits : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_localite_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_localite_global_comment', TextareaType::class, $this->reviewCmtOpts);
        }
    }

    public function getBlockPrefix(): string
    {
        return 'formDistributorSelfEvalPrestaQuiz';
    }
}
