<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\Form\Type\DateTimeRangePickerType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Sonata\AdminBundle\Admin\FieldDescriptionInterface;
use App\Enum\CurrencyEnum;

/**
 * Administration des profils de cotisation.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 */
class ProfilDeCotisationAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'profilcotisation';
    protected $baseRoutePattern = 'profilcotisation';

    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    /**
     * {@inheritdoc}
     */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        $formMapper
            ->with('Profil', ['class' => 'col-md-12'])
                ->add('montant', NumberType::class, [
                    'label' => 'Montant'
                ])
                ->add('tauxCotisation', NumberType::class, [
                    'label' => 'Taux de cotisation'
                ])
            ->end()
        ;

        parent::configureFormFields($formMapper);
    }

    /**
     * {@inheritdoc}
     */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('createdAt', 'doctrine_orm_datetime_range', [
                'field_type' => DateTimeRangePickerType::class,
                'label' => 'Date de création',
            ])
            ->add('updatedAt', 'doctrine_orm_datetime_range', [
                'field_type' => DateTimeRangePickerType::class,
                'label' => 'Date de mise à jour',
            ])
        ;
    }

    protected function configureListFields(ListMapper $listMapper): void
    {
        $listMapper
            ->addIdentifier('montant', FieldDescriptionInterface::TYPE_CURRENCY, [
                'label' => 'Montant',
                'currency' => CurrencyEnum::getCode(CurrencyEnum::CURRENCY_EURO),
                'sortable' => true
            ])
            ->addIdentifier('tauxCotisation', null, [
                'label' => 'Taux de cotisation',
                'sortable' => true
            ])
            ->add('createdAt', 'date', [
                'pattern' => 'dd/MM/YYYY HH:mm',
                'label' => 'Crée le',
            ])
            ->add('updatedAt', 'date', [
                'pattern' => 'dd/MM/YYYY HH:mm',
                'label' => 'Mis à jour le',
            ])
            ->add('_action', null, [
                'actions' => ['edit' => []],
            ])
        ;
    }
}
