<?php

namespace App\Utils;

use App\Entity\GlobalParameter;
use App\Utils\CustomEntityManager;
use App\Enum\MoyenEnum;

class MoyensUtils
{
    private $em;

    public function __construct(CustomEntityManager $em) {
        $this->em = $em;
    }

    /**
     * Return available payment types for Comptoir from configuration param value.
     *
     * @return array<string>
     */
    public function getAvailableTypesComptoir()
    {
        $paymentTypes = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::COMPTOIR_PAYMENT_TYPES);

        if (null == $paymentTypes) {
            return $this->getDefaultAvailableTypesComptoir();
        } 

        $paymentTypesArr = explode(",", $paymentTypes);

        try {
            $res = array_map(function ($val) {
                return constant("App\\Enum\\MoyenEnum::$val");
            }, $paymentTypesArr);
        } catch (\Exception $e) {
            // Error in parameter definition
            $res = $this->getDefaultAvailableTypesComptoir();
        }

        return $res;
    }

    public function getDefaultAvailableTypesComptoir() {
        return [
            MoyenEnum::MOYEN_ESPECE,
            MoyenEnum::MOYEN_CHEQUE,
            MoyenEnum::MOYEN_AUTRE,
        ];
    }
}