<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use App\Entity\GlobalParameter;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20250502111501 extends AbstractMigration implements ContainerAwareInterface
{

    /**
     * @var ObjectManager
     */
    protected $em;

    public function setContainer(ContainerInterface $container = null)
    {
        $this->em = $container->get('doctrine')->getManager();
    }

    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        $containerName = trim(file_get_contents('/etc/hostname'));

        if (str_contains($containerName, 'casparis20')) {
            $defaultValue = 'MOYEN_VIREMENT,MOYEN_ESPECE,MOYEN_AUTRE';
        } else {
            $defaultValue = 'MOYEN_ESPECE,MOYEN_CHEQUE,MOYEN_AUTRE';
        }

        $this->addSql("INSERT INTO global_parameter (id, name, description, value, mandatory) VALUES (UUID(), 'COMPTOIR_PAYMENT_TYPES', 'Définit la liste des paiements disponible aux comptoirs. Insérer les valeurs désirées dans l\'ordre séparées par une virgule sans espace. Valeurs possibles : MOYEN_CB, MOYEN_ESPECE, MOYEN_CHEQUE, MOYEN_VIREMENT, MOYEN_HELLOASSO, MOYEN_EMLC, MOYEN_MLC, MOYEN_AUTRE.', '$defaultValue', '0')");
        $this->addSql("DELETE FROM global_parameter where name='ALTERNATE_AVAILABLE_PAYMENT_TYPES_COMPTOIR'");
    }

    public function down(Schema $schema) : void
    {
        $this->addSql("DELETE FROM global_parameter where name='COMPTOIR_PAYMENT_TYPES'");
        $this->addSql("INSERT INTO global_parameter (id, name, description, value, mandatory) VALUES (UUID(), 'ALTERNATE_AVAILABLE_PAYMENT_TYPES_COMPTOIR', 'Active un set de moyens de paiement disponibles alternatif pour les comptoirs. Par défaut : Espèce, Chèque, Autre. Avec ce paramètre activé : Virement, Espèce, Autre.', 'false', '1')");
    }
}
