<?php

namespace App\Repository;

use App\Entity\ExternalDataTheoreticalCotisationRule;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<ExternalDataTheoreticalCotisationRule>
 *
 * @method ExternalDataTheoreticalCotisationRule|null find($id, $lockMode = null, $lockVersion = null)
 * @method ExternalDataTheoreticalCotisationRule|null findOneBy(array $criteria, array $orderBy = null)
 * @method ExternalDataTheoreticalCotisationRule[]    findAll()
 * @method ExternalDataTheoreticalCotisationRule[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 * @method null                                       removeAll()
 */
class ExternalDataTheoreticalCotisationRuleRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ExternalDataTheoreticalCotisationRule::class);
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function add(ExternalDataTheoreticalCotisationRule $entity, bool $flush = true): void
    {
        $this->_em->persist($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function remove(ExternalDataTheoreticalCotisationRule $entity, bool $flush = true): void
    {
        $this->_em->remove($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * Remove all instances of ExternalDataTheoreticalCotisationRule
     */
    public function removeAll() {
        return $this->createQueryBuilder('e')
            ->delete()
            ->getQuery()
            ->execute()
        ;
    }

    // /**
    //  * @return ExternalDataTheoreticalCotisationRule[] Returns an array of ExternalDataTheoreticalCotisationRule objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('e')
            ->andWhere('e.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('e.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?ExternalDataTheoreticalCotisationRule
    {
        return $this->createQueryBuilder('e')
            ->andWhere('e.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
