<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251009075632 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE caissier DROP FOREIGN KEY FK_1F038BC2A76ED395');
        $this->addSql('ALTER TABLE caissier DROP FOREIGN KEY FK_1F038BC2BE3DB2B7');
        $this->addSql('ALTER TABLE caissier CHANGE last_transactions_export_datetime last_transactions_export_datetime DATETIME DEFAULT NULL');
        $this->addSql('DROP INDEX idx_ff8e6fc2a76ed395 ON caissier');
        $this->addSql('CREATE INDEX IDX_1F038BC2A76ED395 ON caissier (user_id)');
        $this->addSql('DROP INDEX idx_ff8e6fc2be3db2b7 ON caissier');
        $this->addSql('CREATE INDEX IDX_1F038BC2BE3DB2B7 ON caissier (prestataire_id)');
        $this->addSql('ALTER TABLE caissier ADD CONSTRAINT FK_1F038BC2A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE caissier ADD CONSTRAINT FK_1F038BC2BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id)');
        $this->addSql('CREATE UNIQUE INDEX adherentyear ON external_adherent_dated_data (adherent_id, year)');
        $this->addSql('ALTER TABLE prestataire CHANGE iban iban LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:personal_data)\'');
        $this->addSql("INSERT INTO global_parameter (id, name, description, value, mandatory) VALUES (UUID(), 'SSA_ADH_EXTERNAL_DATA_COHORTES_LIST', 'Si les données de suivi sont activées (paramètre USE_EXTERNAL_DATA), définit les valeurs de la liste des roulantes des cohortes. Insérer les valeurs désirées dans l\'ordre séparées par une virgule sans espace.', NULL, '0')");
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE caissier DROP FOREIGN KEY FK_1F038BC2A76ED395');
        $this->addSql('ALTER TABLE caissier DROP FOREIGN KEY FK_1F038BC2BE3DB2B7');
        $this->addSql('ALTER TABLE caissier CHANGE last_transactions_export_datetime last_transactions_export_datetime DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\'');
        $this->addSql('DROP INDEX idx_1f038bc2be3db2b7 ON caissier');
        $this->addSql('CREATE INDEX IDX_FF8E6FC2BE3DB2B7 ON caissier (prestataire_id)');
        $this->addSql('DROP INDEX idx_1f038bc2a76ed395 ON caissier');
        $this->addSql('CREATE INDEX IDX_FF8E6FC2A76ED395 ON caissier (user_id)');
        $this->addSql('ALTER TABLE caissier ADD CONSTRAINT FK_1F038BC2A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE caissier ADD CONSTRAINT FK_1F038BC2BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id)');
        $this->addSql('DROP INDEX adherentyear ON external_adherent_dated_data');
        $this->addSql('ALTER TABLE prestataire CHANGE iban iban LONGTEXT CHARACTER SET utf8mb3 DEFAULT NULL COLLATE `utf8mb3_general_ci` COMMENT \'(DC2Type:personal_data)\'');
        $this->addSql("DELETE FROM global_parameter where name='SSA_ADH_EXTERNAL_DATA_COHORTES_LIST'");
    }
}
