<?php

namespace App\Form\Type;

use App\Entity\User;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('email', EmailType::class, [
                'label' => 'Courriel',
                'required' => true,
                'translation_domain' => 'FOSUserBundle',
            ])
            ->add('firstname', TextType::class, [
                'label' => 'Prénom',
                'required' => true,
            ])
            ->add('lastname', TextType::class, [
                'label' => 'Nom',
                'required' => true,
            ])
            ->add('phone', TextType::class, [
                'label' => 'Téléphone fixe :',
                'required' => false,
            ])
            ->add('mobile', TextType::class, [
                'label' => 'Téléphone mobile :',
                'required' => false,
            ])
            ->add('comment', null, [
                'label' => 'Commentaire',
                'required' => false,
                'attr' => array(
                    'placeholder' => 'Indiquez par exemple pourquoi ce compte a été désactivé'
                )
            ])
            ->add('enabled', null, [
                'label' => 'Activé ?',
                'attr' => ['autocomplete' => 'off']
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'cascade_validation' => true,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'user_form';
    }
}
