<?php

namespace App\Form\Type;

use App\Entity\GlobalParameter;
use App\Entity\Siege;
use App\Enum\MoyenEnum;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\RangeType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class AchatMonnaieFormType extends FluxFormType
{
    private $defaultMontantSlider = 30;
    private $maxMontantSlider = 250;

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('moyen', HiddenType::class, [
                'data' => MoyenEnum::MOYEN_CB,
            ])
            ->add('reconverti', HiddenType::class, [
                'data' => false,
                'empty_data' => false,
            ])
            ->add('expediteur', HiddenType::class, [
                'data' => $this->em->getRepository(Siege::class)->getTheOne(),
                'data_class' => null,
                'entity_class' => Siege::class,
                'em' => $this->em,
            ])
        ;

        if ($this->container->getParameter('tav_env')) {
            $montant = 0;

            if ($this->container->getParameter('simplified_household_based_allowance')) {
                // if no cotisation amount, get amount from profil de cotisation instead if set
                // (for transition purposes from other allocation process)
                $cosisationMontant = $this->security->getUser()->getAdherent()->getCotisationAmount();
                if (null != $cosisationMontant) {
                    $montant = $cosisationMontant;
                } else {
                    $profilDeCotisation = $this->security->getUser()->getAdherent()->getProfilDeCotisation();
                    if (null != $profilDeCotisation) {
                        $montant = $profilDeCotisation->getMontant();
                    } else {
                        $montant = false;
                    }
                }
            } else if ($this->container->getParameter('household_based_allowance')) {
                $cosisationMontant = $this->security->getUser()->getAdherent()->getCotisationAmount();
                if (null != $cosisationMontant) {
                    $montant = $cosisationMontant;
                } else {
                    $montant = false;
                }

            } else {
                $profilDeCotisation = $this->security->getUser()->getAdherent()->getProfilDeCotisation();
                if (null != $profilDeCotisation) {
                    $montant = $profilDeCotisation->getMontant();
                } else {
                    $montant = false;
                }
            }

            $builder
                ->add('montant', HiddenType::class, [
                    'data' => $montant,
                ])
            ;
        } else {
            $builder
                ->add('montantradio', ChoiceType::class, [
                    'choices' => [
                        '30 €' => 30,
                        '50 €' => 50,
                        '100 €' => 100,
                    ],
                    'required' => false,
                    'placeholder' => false,
                    'data' => $this->defaultMontantSlider,
                    'expanded' => true,
                    'multiple' => false,
                    'label' => 'Sélectionnez un montant :',
                    'mapped' => false,
                ])
                ->add('montant', RangeType::class, [
                    'attr' => [
                        'min' => 0,
                        'max' => $this->maxMontantSlider,
                        'data-provide' => 'slider',
                        'data-slider-ticks' => '[0, 50, 100, 150, 200, 250]',
                        'data-slider-ticks-labels' => '[0, 50, 100, 150, 200, 250]',
                        'data-slider-ticks-positions' => '[0, 20, 40, 60, 80, 100]',
                        'data-slider-min' => '0',
                        'data-slider-max' => $this->maxMontantSlider,
                        'data-slider-step' => '5',
                        'data-slider-value' => $this->defaultMontantSlider,
                        'style' => 'width:100%;',
                        'class' => 'achatmonnaie-montant-slider',
                    ],
                    'label' => 'Ou choisissez librement le montant : ',
                    'required' => false,
                ])
                ->add('payOther', SubmitType::class, [
                    'label' => 'Payer autrement',
                    'translation_domain' => 'messages',
                    'attr' => [
                        'class' => 'btn-secondary',
                    ],
                ])
            ;
        }

        if ('true' === $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::USE_PAYZEN)) {
            $builder
                ->add('save', SubmitType::class, [
                    'label' => 'Payer en CB',
                    'translation_domain' => 'messages',
                    'attr' => [
                        'class' => 'btn-primary btn achatCBSubmit',
                    ],
                ])
            ;
        }
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaie';
    }
}
