<?php

namespace App\Entity;

use App\Repository\ExternalDataTheoreticalCotisationRuleRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=ExternalDataTheoreticalCotisationRuleRepository::class)
 * 
 * This class stores data used to calculate the theoritical cotisation amount of a Adherent.
 * For each allocation bracket (allocationAmount), and for each income bracket (incomeMin < x <= incomeMax),
 *  cotisation is calculated as such : f(x) = coef * x + intercept ;
 *  with x as the Adherent's monthly income.
 * 
 * This data is used for visualisation purposes in an external Metabase instance.
 */
class ExternalDataTheoreticalCotisationRule
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     */
    private $allocationAmount;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2, nullable=true)
     */
    private $incomeMin;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2, nullable=true)
     */
    private $incomeMax;

    /**
     * @ORM\Column(type="decimal", precision=18, scale=16, nullable=true)
     */
    private $coef;

    /**
     * @ORM\Column(type="decimal", precision=18, scale=15, nullable=true)
     */
    private $intercept;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2, nullable=true)
     */
    private $fixedValue;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAllocationAmount(): ?int
    {
        return $this->allocationAmount;
    }

    public function setAllocationAmount(int $allocationAmount): self
    {
        $this->allocationAmount = $allocationAmount;

        return $this;
    }

    public function getIncomeMin(): ?float
    {
        return $this->incomeMin;
    }

    public function setIncomeMin(?float $incomeMin): self
    {
        $this->incomeMin = $incomeMin;

        return $this;
    }

    public function getIncomeMax(): ?float
    {
        return $this->incomeMax;
    }

    public function setIncomeMax(?float $incomeMax): self
    {
        $this->incomeMax = $incomeMax;

        return $this;
    }

    public function getCoef(): ?float
    {
        return $this->coef;
    }

    public function setCoef(float $coef): self
    {
        $this->coef = $coef;

        return $this;
    }

    public function getIntercept(): ?float
    {
        return $this->intercept;
    }

    public function setIntercept(float $intercept): self
    {
        $this->intercept = $intercept;

        return $this;
    }

    public function getFixedValue(): ?float
    {
        return $this->fixedValue;
    }

    public function setFixedValue(?float $fixedValue): self
    {
        $this->fixedValue = $fixedValue;

        return $this;
    }
}
