<?php

namespace App\Entity;
use Doctrine\ORM\Mapping as ORM;

/**
 * Child class used to notify adherents by email.
 *
 * - [Allocation selon foyer] Un administrateur effectue une opération de correction de solde qui conduit à un reversement.
 * @ORM\Entity
 */
class CotisationTavReversementCorrectionSolde extends CotisationTavReversement
{
    /**
     * @return string
     */
    public function getType(): string
    {
        return parent::TYPE_REVERSEMENT_COTISATION_ADHERENT_CORRECTION_SOLDE;
    }

    public function getUsersToNotify()
    {
        return [
            'destinataires' => [$this->getDestinataire()->getUser()],
        ];
    }
}
