<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Administration des paramètres généraux de l'outil de MLC.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class GlobalParameterAdmin extends AbstractAdmin
{
    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    /**
     * {@inheritdoc}
     */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $formMapper
            ->add('name', TextType::class, [
                'label' => 'Nom :',
                'attr' => ['class' => 'text-uppercase'],
            ])
            ->add('description', TextType::class, [
                'label' => 'Description :',
            ])
            ->add('value', TextType::class, [
                'label' => 'Valeur :',
            ])
            ->add('mandatory', HiddenType::class, [
                'empty_data' => false,
                'data' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->add('name', null, ['label' => 'Nom'])
            ->add('description', null, ['label' => 'Description'])
            ->add('value', null, ['editable' => true, 'truncate' => ['length' => 80], 'label' => 'Value'])
            ->add('_action', null, [
                'label' => 'Action(s)',
                'actions' => [
                    'edit' => ['template' => '@kohinos/bundles/SonataAdminBundle/CRUD/list__action_edit_gp.html.twig'],
                    'delete' => ['template' => '@kohinos/bundles/SonataAdminBundle/CRUD/list__action_delete_gp.html.twig'],
                ],
            ])
        ;
    }

    public function getTemplate($name)
    {
        if ('list' == $name) {
            return '@kohinos/admin/globalparameter_list.html.twig';
        }

        return parent::getTemplate($name);
    }

    public function getBatchActions()
    {
        $actions = parent::getBatchActions();
        unset($actions['delete']);
        unset($actions['edit']);

        return $actions;
    }
}
