<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20250415103920 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '
        For SSA ("tav") projects, configure the presence / absence and content of quartier and subterritory in adherent profile.
        At the time this migration is created, subterritory flag has different values in two different project already in production.
        This is why we have a rule to decide what should be default value for it. 
        ';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql("INSERT INTO global_parameter (id, name, description, value, mandatory) VALUES (UUID(), 'SSA_HOUSEHOLD_WITH_QUARTIER', 'En mode SSA, si la valeur est à true, affiche le champ \'Quartier\' dans la fiche Adhérent.', 'true', '0')");
        $this->addSql("INSERT INTO global_parameter (id, name, description, value, mandatory) VALUES (UUID(), 'SSA_HOUSEHOLD_QUARTIER_LIST_VALUES', 'En mode SSA, si le champ \'Quartier\' est affiché et que ce paramètre est renseigné, affiche le champ sous forme de liste déroulante plutôt que de champ libre. Renseigner les valeurs séparées par une virgule sans espace (ex: Facultés,Hôpitaux,Montpellier Ouest,Gambetta).', '', '0')");


        $containerName = trim(file_get_contents('/etc/hostname'));

        if (str_contains($containerName, 'ssagironde')) {
            $withSubterritoryDefaultValue = 'true';
        } else {
            $withSubterritoryDefaultValue = 'false';
        }

        $this->addSql("
INSERT INTO global_parameter (id, name, description, value, mandatory)
VALUES (
        UUID(),
        'SSA_HOUSEHOLD_WITH_SUBTERRITORY',
        'En mode SSA, si la valeur est à true, affiche le champ \'Territoire\' dans la fiche Adhérent.',
        '$withSubterritoryDefaultValue',
        '0'
        )
        ");
    }

    public function down(Schema $schema) : void
    {
        $this->addSql("DELETE FROM global_parameter where name='SSA_HOUSEHOLD_WITH_QUARTIER'");
        $this->addSql("DELETE FROM global_parameter where name='SSA_HOUSEHOLD_QUARTIER_LIST_VALUES'");
        $this->addSql("DELETE FROM global_parameter where name='SSA_HOUSEHOLD_WITH_SUBTERRITORY'");
        // this down() migration is auto-generated, please modify it to your needs
    }
}
