<?php

namespace App\Form\Type;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class SetPaymentCodeFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('payment_code', PasswordType::class, [
                'label' => 'Saisir mon nouveau code (4 à 8 chiffres)',
                'required' => true,
                'attr' => ['autocomplete' => 'off']
            ])
            ->add('save', SubmitType::class, ['label' => 'Valider'])
        ;
    }

    public function getBlockPrefix()
    {
        return 'formSetPaymentCode';
    }
}
