<?php

namespace App\Form\Type;

use App\Entity\SelfEvalPrestaQuiz;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

/**
 *
 * Self-eval prestataire questionnaire base class
 * containing useful attributes and buildForm for
 * sections that are common to distributors and producers
 */
class SelfEvalPrestaQuizType extends AbstractType
{
    const PRESTA_EDIT = 'presta_edit';
    const ADMIN_EDIT = 'admin_edit';
    const READONLY = 'readonly';
    const PRESTA_EDIT_AFTER_DEFINITIVE_SUBMISSION = 'presta_edit_after_definitive_submission';

    protected $security;

    protected array $stdChoices;
    protected array $opts;
    protected array $reviewOpts;
    protected array $cmtOpts;
    protected array $globalCmtOpts;
    protected array $reviewCmtOpts;
    protected string $labelEvalGlob;
    protected string $reviewLabel;
    protected string $frown;
    protected string $meh;
    protected string $smile;

    public function __construct(Security $security, array $options = [])
    {
        $this->security = $security;

        $this->frown = '<i class="fas fa-frown text-danger"></i>';
        $this->meh = '<i class="fas fa-meh text-warning"></i>';
        $this->smile = '<i class="fas fa-smile text-success"></i>';

        $this->stdChoices = [
            $this->frown . ' non' => 0,
            $this->meh . ' peut être amélioré' => 1,
            $this->smile . ' oui' => 2,
        ];
        $this->stdGlobalChoices = [
            $this->frown => 0,
            $this->meh => 1,
            $this->smile => 2,
        ];
        $this->labelEvalGlob = "évaluation globale";
        $this->reviewLabel = "évaluation du gestionnaire";
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        //options are moved to buildForm as 'mode' option is required to set them up
        $this->reviewOpts = [
            'label' => '',
            'choices' => $this->stdChoices,
            'expanded' => true,
            "multiple" => false,
            'disabled' => $options['mode'] !== self::ADMIN_EDIT
        ];
        $this->opts = $this->reviewOpts;
        $this->opts['disabled'] = $options['mode'] !== self::PRESTA_EDIT && $options['mode'] !== self::PRESTA_EDIT_AFTER_DEFINITIVE_SUBMISSION;
        $this->reviewCmtOpts = [
            'attr' => [
                'placeholder' => $options['mode'] !== self::ADMIN_EDIT ? '' : 'Commentaires'
            ],
            'label' => false,
            'required' => false,
            'disabled' => $options['mode'] !== self::ADMIN_EDIT
        ];

        $this->cmtOpts = $this->reviewCmtOpts;
        $this->cmtOpts['disabled'] = $options['mode'] !== self::PRESTA_EDIT && $options['mode'] !== self::PRESTA_EDIT_AFTER_DEFINITIVE_SUBMISSION;
        $this->cmtOpts['attr']['placeholder'] = $options['mode'] !== self::PRESTA_EDIT ? '' : 'Commentaires';

        $this->globalCmtOpts = $this->cmtOpts;
        $this->globalCmtOpts['required'] = true;
        $this->globalCmtOpts['attr']['placeholder'] = $options['mode'] !== self::PRESTA_EDIT && $options['mode'] !== self::PRESTA_EDIT_AFTER_DEFINITIVE_SUBMISSION ? '' : 'Commentaires (obligatoire)';

        $builder->add($options["mode"],HiddenType::class,['mapped' => false]); //ease conditionnal display in twig

        /* PARTIE 1 : ACCESSIBILITE ET INCLUSIVITE */
        $this->opts['label'] = "Géographique et physique : le point de vente est-il accessible par différents modes de transport ?";
        $this->opts['choices'] = [
            $this->frown . " 0 mode de transport" => 0,
            $this->meh . " 1 mode de transport" => 1,
            $this->smile . " plus d'1 mode de transport" => 2,
        ];
        $builder->add('accessib_geophy', ChoiceType::class, $this->opts);
        $builder->add('accessib_geophy_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Temporelle : le point de vente communique-t-il sur ses plages d'ouvertures ?";
        $this->opts['choices'] = [
            $this->frown . " 0 mode de communication" => 0,
            $this->meh . " 1 mode de communication" => 1,
            $this->smile . " plus d'1 mode de communication" => 2,
        ];
        $builder->add('accessib_tempor', ChoiceType::class, $this->opts);
        $builder->add('accessib_tempor_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Sociale et inclusivité (1/3) : le point de vente mène-t-il des actions de sensibilisation et d'éducation populaire à l'alimentation ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('accessib_edupop', ChoiceType::class, $this->opts);
        $builder->add('accessib_edupop_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Sociale et inclusivité (2/3) : le point de vente propose-t-il des services spécifiques pour faciliter son accessibilité à une diversité
                de profils (pour les personnes agées, les personnes en situation de handicap, les familles ...) ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('accessib_divers', ChoiceType::class, $this->opts);
        $builder->add('accessib_divers_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Sociale et inclusivité (3/3) : le point de vente mène-t-il des actions spécifiques pour lutter contre la vulnérabilité alimentaire ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('accessib_vulner', ChoiceType::class, $this->opts);
        $builder->add('accessib_vulner_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Accessibilité et inclusivité : " . $this->labelEvalGlob;
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('accessib_global', ChoiceType::class, $this->opts);
        $builder->add('accessib_global_comment', TextareaType::class, $this->globalCmtOpts);

        /* PARTIE 2 : BIEN-ETRE AU TRAVAIL */
        $this->opts['label'] = "Le point de vente met-il en place des actions pour faciliter l'accueil, l'intégration et la formation des personnes qui y travaillent ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('bienetre_format', ChoiceType::class, $this->opts);
        $builder->add('bienetre_format_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les travailleurs sont-ils impliqués dans la gouvernance ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('bienetre_impgou', ChoiceType::class, $this->opts);
        $builder->add('bienetre_impgou_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Le point de vente met-il en place des actions pour améliorer le bien-être des personnes qui y travaillent ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('bienetre_bienet', ChoiceType::class, $this->opts);
        $builder->add('bienetre_bienet_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Le point de vente met-il en place des actions pour valoriser et reconnaître le travail fourni par les bénévoles ?";
        $this->opts['choices'] = $this->stdChoices;
        $builder->add('bienetre_recben', ChoiceType::class, $this->opts);
        $builder->add('bienetre_recben_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Bien-être au travail : " . $this->labelEvalGlob;
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('bienetre_global', ChoiceType::class, $this->opts);
        $builder->add('bienetre_global_comment', TextareaType::class, $this->globalCmtOpts);

        //Review
        if($options['mode'] !== self::PRESTA_EDIT) {
            $this->reviewOpts['label'] = "Accessibilité et inclusivité : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_accessib_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_accessib_global_comment', TextareaType::class, $this->reviewCmtOpts);

            $this->reviewOpts['label'] = "Bien-être au travail : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_bienetre_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_bienetre_global_comment', TextareaType::class, $this->reviewCmtOpts);
        }

        if($options['mode'] !== self::READONLY) {
            $builder->add('submit_presta_quizz', HiddenType::class, [
                "mapped" => false,
                "data" => 1,
                "empty_data" => 1
            ]);
            $builder->add('save', SubmitType::class, ['label' => $options['mode'] === self::PRESTA_EDIT ? 'Envoyer' : 'Enregistrer']);
        }

        if($options['mode'] == self::PRESTA_EDIT) {
            $builder->add('temporary_save', SubmitType::class, ['label' => 'Sauvegarder afin de revenir plus tard']);
        }
    }

    /**
     *
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => SelfEvalPrestaQuiz::class,
            'mode' => self::PRESTA_EDIT
        ]);
    }

    public function getBlockPrefix(): string
    {
        return 'formSelfEvalPrestaQuiz';
    }
}
