<?php

namespace App\Form\Type;

use App\Entity\Geoloc;
use App\Entity\Subterritory;
use App\Entity\GlobalParameter;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Doctrine\ORM\EntityManagerInterface;

class GeolocFormType extends AbstractType
{
    private $router;
    protected $em;

    public function __construct(RouterInterface $router, EntityManagerInterface $em)
    {
        $this->router = $router;
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $geoloc = null;
        if (!empty($options['data'])) {
            $geoloc = $options['data'];
        }
        $builder
            ->add('adresse', TextType::class, [
                'label' => 'Adresse :',
                'required' => $options['required'],
            ])
            ->add('cpostal', TextType::class, [
                'label' => 'Code postal :',
                'required' => $options['required'],
            ])
            ->add('ville', TextType::class, [
                'label' => 'Ville :',
                'required' => $options['required'],
            ])
        ;
        if (true === $options['with_geoloc']) {
            $builder
                ->add('search', ButtonType::class, [
                    'label' => 'Géolocaliser',
                    'attr' => ['class' => 'searchLatLon btn btn-primary', 'data-url' => $this->router->generate('geolocAdresse')],
                ])
            ;
        }
        if (true === $options['with_latlon'] || (!empty($geoloc) && (!empty($geoloc->getLat()) || !empty($geoloc->getLon())))) {
            $builder
                ->add('lat', null, [
                    'label' => 'Latitude :',
                    'required' => false,
                ])
                ->add('lon', null, [
                    'label' => 'Longitude :',
                    'required' => false,
                ])
            ;
        } else {
            $builder
                ->add('lat', HiddenType::class, [
                    'label' => 'Latitude :',
                    'required' => false,
                ])
                ->add('lon', HiddenType::class, [
                    'label' => 'Longitude :',
                    'required' => false,
                ])
            ;
        }
        if (true === $options['with_quartier']) {
            $quartierListValues = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::GEOLOC_QUARTIER_LIST_VALUES);

            if (null !== $quartierListValues && '' !== $quartierListValues) {
                $quartierListValuesArr = explode(",", $quartierListValues);
                $builder
                    ->add('quartier', ChoiceType::class, [
                        'choices' => $quartierListValuesArr,
                        'choice_label' => function ($choice) {
                            return $choice;
                        },
                        'expanded' => false,
                        'multiple' => false,
                        'required' => false,
                        'attr' => ['autocomplete' => 'off']
                    ])
                ;
            } else {
                $builder
                    ->add('quartier', TextType::class, [
                        'required' => false,
                    ])
                ;
            }
        }
        if (true === $options['with_subterritory']) {
            $builder
                ->add('subterritory', EntityType::class, [
                    'class' => Subterritory::class,
                    'label' => 'Territoire',
                    'required' => true,
                    'choice_label' => 'name',
                    'placeholder' => "Choix du territoire",
                    'attr' => ['autocomplete' => 'off']
                ])
            ;
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        // $resolver->setRequired(['with_latlon']);
        $resolver->setDefaults([
            'data_class' => Geoloc::class,
            'with_geoloc' => true,
            'with_latlon' => true,
            'with_subterritory' => false,
            'with_quartier' => false
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formGeoloc';
    }
}
