<?php

namespace App\Form\Type;

use App\Entity\AchatMonnaieAdherent;
use App\Entity\Adherent;
use App\Entity\DonAdherent;
use App\Entity\GlobalParameter;
use App\Entity\Prestataire;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;

class AchatMonnaieAdherentRecurrentFormType extends AchatMonnaieAdherentFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        //force prelevement to occur on same day as today to make sure next prelevement occurs next month
        //if today is after the 28th, use the 28th so that prelevement always occurs on same date
        $jourPrelevement = min($now->format('d'),28);

        $builder
            ->add('nombreMois', IntegerType::class, [
                'label' => 'Nombre d\'échéances désirées : ',
                'required' => true,
                'mapped' => false,
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 2, 'message' => "Le nombre d'échéances doit être au moins égal à 2."]),
                ],
                'help' => "Une échéance par mois.
                Le premier paiement est inclus dans le nombre d'échéances.
                Le nombre d'échéance réel pourra être diminué selon la date d'expiration du moyen de paiement utilisé.
                Pour demander une interruption anticipée, merci de contacter la caisse.",
                'attr' => ['autocomplete' => 'off']
            ])
            ->add('jourPrelevement', ChoiceType::class, [
                'label' => 'Jour du prélèvement dans le mois : ',
                'choices'  => [strval($jourPrelevement) => $jourPrelevement],
                'data' => $jourPrelevement,
                'required' => true,
                'mapped' => false,
                'attr' => ['autocomplete' => 'off', 'readonly' => true],
                'help' => "Pour simplifier le traitement de l'information, le jour de prélèvement est fixé au jour du premier paiement ou au plus tard le 28 du mois."
            ])
            ->remove('saveHelloAsso')
            ->remove('save')
            ->add('save', SubmitType::class, [
                'label' => 'Payer en CB mon premier paiement et créer un paiement récurrent',
                'translation_domain' => 'messages',
                'attr' => [
                    'class' => 'btn-primary btn achatCBSubmit',
                ],
            ])
            ->remove('reference')
            ->add('reference', HiddenType::class, [
                'data' => AchatMonnaieAdherent::REFERENCE_ACHAT_MONNAIE_ADHERENT_EN_CB_RECURRENT,
            ])
        ;

        $builder
                
            ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'class' => AchatMonnaieAdherent::class,
        ]);
    }

    public function getParent()
    {
        return AchatMonnaieAdherentFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaieAdherentRecurrent';
    }
}
