<?php

namespace App\Entity;

use App\Repository\PrestataireProductFamilyRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @ORM\Entity(repositoryClass=PrestataireProductFamilyRepository::class)
 * @ORM\Table(name="prestataire_product_family", uniqueConstraints={@ORM\UniqueConstraint(name="prestataireproductfamily", columns={"prestataire_id", "product_family_id"})}) )
 * @UniqueEntity(
 *     fields={"prestataire", "productFamily"},
 *     errorPath="productFamily",
 *     message="Famille de produits déjà renseignée, les modifications n'ont pas été enregistrées."
 * )
 */
class PrestataireProductFamily
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=Prestataire::class, inversedBy="prestataireProductFamilies")
     * @ORM\JoinColumn(nullable=false)
     */
    private $prestataire;

    /**
     * @ORM\ManyToOne(targetEntity=ProductFamily::class)
     * @ORM\JoinColumn(nullable=false)
     */
    private $productFamily;

    /**
     * Products list as a string. Not related to any kind of product entity.
     * 
     * @ORM\Column(type="text")
     */
    private $products;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPrestataire(): ?Prestataire
    {
        return $this->prestataire;
    }

    public function setPrestataire(?Prestataire $prestataire): self
    {
        $this->prestataire = $prestataire;

        return $this;
    }

    public function getProductFamily(): ?ProductFamily
    {
        return $this->productFamily;
    }

    public function setProductFamily(?ProductFamily $productFamily): self
    {
        $this->productFamily = $productFamily;

        return $this;
    }

    public function getProducts(): ?string
    {
        return $this->products;
    }

    public function setProducts(string $products): self
    {
        $this->products = $products;

        return $this;
    }
}
