<?php

namespace App\Form\Type;

use App\Entity\GlobalParameter;
use App\Enum\MoyenEnum;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class VenteFormType extends TicketFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $alternatePaymentTypes = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::ALTERNATE_AVAILABLE_PAYMENT_TYPES_COMPTOIR);
        $builder
            ->add('moyen', ChoiceType::class, [
                'required' => true,
                'choices' => ('true' === $alternatePaymentTypes) ? MoyenEnum::getAlternateAvailableTypesComptoir() : MoyenEnum::getAvailableTypesComptoir(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
            ])
        ;
    }

    public function getParent()
    {
        return TicketFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formVente';
    }
}
