<?php

namespace App\Form\Type;

use App\Application\Sonata\MediaBundle\Entity\Media;
use App\Entity\Prestataire;
use App\Entity\PrestataireProductFamily;
use App\Form\Type\PrestataireProductFamilyFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use App\Enum\ReconversionFrequencyEnum;
use App\Entity\GlobalParameter;

class PrestataireInfosFormType extends AbstractType
{
    protected $em;
    protected $container;

    public function __construct(EntityManagerInterface $em, ContainerInterface $container)
    {
        $this->em = $em;
        $this->container = $container;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $presta = $options['data'];
        if (null != $presta->getMedia()) {
            $prestaMedia = $this->em->getRepository(Media::class)->findOneById($presta->getMedia()->getId());
        }
        $caissiers = '';
        if (count($presta->getCaissiers()) > 0) {
            foreach ($presta->getCaissiers() as $caissier) {
                if ('' !== $caissiers) {
                    $caissiers .= ';';
                }
                $caissiers .= $caissier->getEmail();
            }
        }
        $builder
            ->add('media', MediaType::class, [
                'provider' => 'sonata.media.provider.image',
                'context' => 'prestataire',
                'label' => 'Image',
            ])
            ->add('raison', TextType::class, [
                'label' => 'Raison :',
                'required' => true,
            ])
            ->add('statut', TextType::class, [
                'label' => 'Activité :',
                'required' => false,
            ])
            ->add('siret', TextType::class, [
                'label' => 'SIRET :',
                'required' => false,
            ])
            //bic is new field in kohinos-ssa (I think it's OK to add it for non-tav env as well)
            ->add('bic', TextType::class, [
                'label' => 'BIC :',
                'required' => false,
            ])
            ->add('iban', TextType::class, [
                'label' => 'IBAN :',
                'required' => false,
            ])
            ->add('responsable', TextType::class, [
                'label' => 'Responsable :',
                'required' => false,
            ])
            ->add('metier', TextType::class, [
                'label' => 'Métier responsable :',
                'required' => false,
            ])
            ->add('horaires', TextType::class, [
                'label' => 'Horaires :',
                'required' => false,
            ])
            ->add('web', UrlType::class, [
                'label' => 'Site web :',
                'required' => false,
            ]);

        if ($this->container->getParameter('tav_env') && $this->container->getParameter('automatisation_reconversion')) {
            
            $mlcName = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::MLC_NAME_SMALL);

            // If a paying entity is defined, add to to help message
            $helpMsg = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::RECONVERSION_FREQUENCY_HELP_TEXT);
            $helpMsg = is_null($helpMsg) ? '' : $helpMsg;

            $builder
                ->add('reconversionFrequency', ChoiceType::class, [
                    'choices' => ReconversionFrequencyEnum::getAvailableTypes(),
                    'choice_label' => function ($choice) {
                        return ReconversionFrequencyEnum::getTypeName($choice);
                    },
                    'expanded' => false,
                    'multiple' => false,
                    'label' => 'Fréquence de reconversion :',
                    'placeholder' => 'Choisir une option',
                    'required' => false,
                    'help' => $helpMsg
                ]);
        }

        if ($this->container->getParameter('tav_env') && $this->container->getParameter('presta_extra_data')) {
            $builder
                ->add('prestataireProductFamilies', CollectionType::class, [
                    'entry_type' => PrestataireProductFamilyFormType::class,
                    'required' => true,
                    'allow_add' => true,
                    'allow_delete' => true,
                    'by_reference' => false,
                    'constraints' => new \Symfony\Component\Validator\Constraints\Valid(),
                    'label' => "Produits vendus, regroupés par famille ",
                    'error_mapping' => [
                        'productFamily' => 'prestataireProductFamilies',
                    ],
                ]);
        }

        $builder
            ->add('description', CKEditorType::class, [
                'label' => 'Description :',
                'required' => false,
            ])
            ->add('acceptemlc', CheckboxType::class, [
                'label' => 'Accepter la monnaie locale électronique',
                'required' => false,
            ])
            ->add('newcaissiers', TextType::class, [
                'mapped' => false,
                'required' => false,
                'data' => $caissiers,
                'label' => 'Caissier(s) :',
                'help' => 'Ajouter par email séparé par un point virgule (email1;email2;...)',
            ])
            ->add('geolocs', CollectionType::class, [
                'entry_type' => GeolocPrestataireFormType::class,
                'entry_options' => ['label' => false, 'with_latlon' => false],
                'required' => false,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'label' => false,
            ])
            ->add('save', SubmitType::class, ['label' => 'Valider les modifications'])
        ;

        if ($this->container->getParameter('tav_env') && $this->container->getParameter('ccas_mode')) {
            $builder
                ->add('ccasOk', CheckboxType::class, [
                    'label' => 'Si concerné : d\'accord pour la procédure des aides facultatives CCAS',
                    'required' => false,
                    'attr' => ['autocomplete' => 'off']
                ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Prestataire::class,
            'cascade_validation' => true,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formPrestataireInfos';
    }
}
