<?php

namespace App\Enum;

abstract class ReconversionFrequencyEnum
{
    const MOYEN_ONCE_A_MONTH = 'once_a_month';
    const MOYEN_TWICE_A_MONTH = 'twice_a_month';
    const MOYEN_ONCE_TWO_MONTHS = 'once_every_two_month';

    /** @var array user friendly named type */
    protected static $typeName = [
        self::MOYEN_ONCE_A_MONTH => '1 fois par mois',
        self::MOYEN_TWICE_A_MONTH => '2 fois par mois',
        self::MOYEN_ONCE_TWO_MONTHS => '1 fois tous les deux mois',
    ];

    /**
     * @param string $typeShortName
     *
     * @return string
     */
    public static function getTypeName($typeShortName)
    {
        if (!isset(static::$typeName[$typeShortName])) {
            return "Unknown type ($typeShortName)";
        }

        return static::$typeName[$typeShortName];
    }

    /**
     * @return array<string>
     */
    public static function getAvailableTypes()
    {
        return [
            self::MOYEN_ONCE_A_MONTH,
            self::MOYEN_TWICE_A_MONTH,
            self::MOYEN_ONCE_TWO_MONTHS,
        ];
    }
}
