<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\Form\Type\DateTimeRangePickerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Sonata\AdminBundle\Route\RouteCollection;
use App\Entity\Adherent;

/**
 * Administration des simili flux représentant les prises en charges des tiers financeurs.
 * Un flux dans le Kohinos comprend un échange d'eMlc, c'est pourquoi cette entité n'est pas un flux.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 */
class ThirdPartyAllocationFundingAdmin extends AbstractAdmin
{
    protected function configureDatagridFilters(DatagridMapper $datagrid): void
    {
        $datagrid
            ->add('createdAt', 'doctrine_orm_datetime_range', [
                'field_type' => DateTimeRangePickerType::class,
                'show_filter' => true,
                'label' => 'Date',
            ])
            ->add('thirdPartyFinancer', null, [
                'label' => 'Tiers financeur',
                'show_filter' => true,
                'advanced_filter' => false,
            ])
            ->add('adherent', null, [
                'label' => 'Adhérent',
                'show_filter' => true,
                'advanced_filter' => false,
            ])
        ;
    }

    protected function configureListFields(ListMapper $list): void
    {
        $subject = $this->getSubject();
        $list
            ->addIdentifier('created_at', 'datetime', [
                'label' => 'Date'
            ])
            ->addIdentifier('amount', null, [
                'label' => 'Montant'
            ])
            ->addIdentifier('adherent', null, [
                'label' => 'Adhérent'
            ])
            ->addIdentifier('thirdPartyFinancer', null, [
                'label' => 'Tiers financeur'
            ])
            ->addIdentifier('cotisationFlux.montant', null, [
                'label' => 'Montant cotisé'
            ])
            ->addIdentifier('allocationAmount', null, [
                'label' => 'Allocation'
            ])
            ->addIdentifier('reference', null, [
                'label' => 'Référence'
            ])
        ;
    }

    public function getExportFields()
    {
        return [
            'Date' => 'created_at',
            'Montant' => 'amount',
            'Adhérent' => 'adherent.fullname',
            'Tiers financeur' => 'thirdPartyFinancer',
            'Montant cotisé' => 'cotisationFlux.montant',
            'Allocation' => 'allocationAmount',
            'Référence' => 'reference',
        ];
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept(['list', 'export']);
    }
}