<?php

namespace App\Form\Type;

use App\Entity\PrestataireProductFamily;
use App\Entity\ProductFamily;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


class PrestataireProductFamilyFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('productFamily', EntityType::class, array(
                'class'     => ProductFamily::class,
                'choice_label' => 'name',
                'label' => false,
                'required' => true,
                'placeholder' => 'Choisissez une famille de produits',
                'attr' => ['class' => 'prestataire-product-families-select']
            ))
            ->add('products', TextareaType::class, [
                'label' => false,
                'required' => true,
                'attr' => [
                    'class' => 'prestataire-product-families-products',
                    'placeholder' => 'Renseignez des produits correspondant à cette famille'
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => PrestataireProductFamily::class,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formPrestataireProductFamily';
    }
}
