<?php

namespace App\Form\Type;

use App\Entity\DependentChild;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityManagerInterface;
use App\Entity\GlobalParameter;


class DependentChildFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $dependantChildAge = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::SSA_HOUSEHOLD_DEPENDANT_CHILD_LIMIT_AGE);

        $builder
            ->add('olderThanLimitAge', ChoiceType::class, array(
                'choices' => [
                    'oui' => true,
                    'non' => false
                ],
                'label' => "A-t-il plus de {$dependantChildAge} ans ?",
                'required' => true,
                'expanded' => true
            ))
        ;

        if ('true' === $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::SSA_HOUSEHOLD_USE_SHARED_CUSTODY)) {
            $builder
                ->add('sharedCustodyPercentage', ChoiceType::class, [
                    'label' => "Est-il en garde partagée ?",
                    'required' => true,
                    'choices' => [
                        'non' => null,
                        'oui : je le garde 25 % du temps' => '0.25',
                        'oui : je le garde 50 % du temps' => '0.50',
                        'oui : je le garde 75 % du temps' => '0.75',
                    ],
                    'required' => false,
                    'attr' => ['autocomplete' => 'off'] //avoid non-saved value to be displayed
                ])
            ;
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => DependentChild::class,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formDependentChild';
    }
}
