<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251217103039 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE third_party_allocation_funding (id INT AUTO_INCREMENT NOT NULL, adherent_id CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', third_party_financer_id INT NOT NULL, cotisation_flux_id CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', allocation_flux_id CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', amount DOUBLE PRECISION NOT NULL, reference VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX IDX_DBA138125F06C53 (adherent_id), INDEX IDX_DBA13812FFF280D (third_party_financer_id), UNIQUE INDEX UNIQ_DBA1381363D74 (cotisation_flux_id), UNIQUE INDEX UNIQ_DBA13818704443C (allocation_flux_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_general_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE third_party_financer (id INT AUTO_INCREMENT NOT NULL, geoloc_id CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, funding_amount DOUBLE PRECISION NOT NULL, UNIQUE INDEX UNIQ_C52E80E4EF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_general_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE third_party_allocation_funding ADD CONSTRAINT FK_DBA138125F06C53 FOREIGN KEY (adherent_id) REFERENCES adherent (id)');
        $this->addSql('ALTER TABLE third_party_allocation_funding ADD CONSTRAINT FK_DBA13812FFF280D FOREIGN KEY (third_party_financer_id) REFERENCES third_party_financer (id)');
        $this->addSql('ALTER TABLE third_party_allocation_funding ADD CONSTRAINT FK_DBA1381363D74 FOREIGN KEY (cotisation_flux_id) REFERENCES flux (id)');
        $this->addSql('ALTER TABLE third_party_allocation_funding ADD CONSTRAINT FK_DBA13818704443C FOREIGN KEY (allocation_flux_id) REFERENCES flux (id)');
        $this->addSql('ALTER TABLE third_party_financer ADD CONSTRAINT FK_C52E80E4EF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE adherent ADD third_party_financer_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE adherent ADD CONSTRAINT FK_90D3F0602FFF280D FOREIGN KEY (third_party_financer_id) REFERENCES third_party_financer (id)');
        $this->addSql('CREATE INDEX IDX_90D3F0602FFF280D ON adherent (third_party_financer_id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE adherent DROP FOREIGN KEY FK_90D3F0602FFF280D');
        $this->addSql('ALTER TABLE third_party_allocation_funding DROP FOREIGN KEY FK_DBA13812FFF280D');
        $this->addSql('DROP TABLE third_party_allocation_funding');
        $this->addSql('DROP TABLE third_party_financer');
        $this->addSql('DROP INDEX IDX_90D3F0602FFF280D ON adherent');
        $this->addSql('ALTER TABLE adherent DROP third_party_financer_id');
    }
}
