<?php

namespace App\Form\Type;

use App\Entity\ExternalAdherentData;
use App\Entity\GlobalParameter;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityManagerInterface;


class ExternalAdherentDataFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $cohortesList = $this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::SSA_ADH_EXTERNAL_DATA_COHORTES_LIST);
        $cohortesListArr = [];
        foreach (explode(",", $cohortesList) as $cohorte) {
            $cohortesListArr[$cohorte] = $cohorte;
        }


        $builder
            ->add('cohort',ChoiceType::class, [
                'choices' => $cohortesListArr,
                'label' => "Cohorte",
                'required' => false,
                'attr' => [
                    'autocomplete' => 'off'
                ],
                'placeholder' => "Choix de la cohorte",
            ])
            ->add('external_id', TextType::class, [
                'label' => 'ID externe',
                'required' => false,
                'attr' => [
                    'autocomplete' => 'off'
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ExternalAdherentData::class,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formExternalAdherentData';
    }
}
