<?php

namespace App\Entity;

use App\Repository\ThirdPartyAllocationFundingRepository;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * Stores the information that a third party financer funded an adherent as (s)he gets their allocation.
 * This is not a Flux as it doesn't includes an eMlc exchange.
 * 
 * @ORM\Entity(repositoryClass=ThirdPartyAllocationFundingRepository::class)
 */
class ThirdPartyAllocationFunding
{
    use TimestampableEntity;

    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float")
     */
    private $amount;

    /**
     * @ORM\ManyToOne(targetEntity=Adherent::class)
     */
    private $adherent;

    /**
     * @ORM\ManyToOne(targetEntity=ThirdPartyFinancer::class, inversedBy="thirdPartyAllocationFundings")
     * @ORM\JoinColumn(nullable=false)
     */
    private $thirdPartyFinancer;

    /**
     * @ORM\OneToOne(targetEntity=Flux::class, cascade={"persist", "remove"})
     */
    private $cotisationFlux;

    /**
     * @ORM\OneToOne(targetEntity=Flux::class, cascade={"persist", "remove"})
     */
    private $allocationFlux;

    /**
     * @ORM\Column(type="float", options={"default": 0.00})
     */
    private $allocationAmount = 0;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $reference;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getAdherent(): ?Adherent
    {
        return $this->adherent;
    }

    public function setAdherent(?Adherent $adherent): self
    {
        $this->adherent = $adherent;

        return $this;
    }

    public function getThirdPartyFinancer(): ?ThirdPartyFinancer
    {
        return $this->thirdPartyFinancer;
    }

    public function setThirdPartyFinancer(?ThirdPartyFinancer $thirdPartyFinancer): self
    {
        $this->thirdPartyFinancer = $thirdPartyFinancer;

        return $this;
    }

    public function getCotisationFlux(): ?Flux
    {
        return $this->cotisationFlux;
    }

    public function setCotisationFlux(?Flux $cotisationFlux): self
    {
        $this->cotisationFlux = $cotisationFlux;

        return $this;
    }

    public function getAllocationFlux(): ?Flux
    {
        return $this->allocationFlux;
    }

    public function setAllocationFlux(?Flux $allocationFlux): self
    {
        $this->allocationFlux = $allocationFlux;

        return $this;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function setReference(string $reference): self
    {
        $this->reference = $reference;

        return $this;
    }

    public function getAllocationAmount(): ?float
    {
        return $this->allocationAmount;
    }

    public function setAllocationAmount(float $allocationAmount): self
    {
        $this->allocationAmount = $allocationAmount;

        return $this;
    }
}
