<?php

namespace App\Entity;

use App\Repository\InformationPopupRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Doctrine\UuidGenerator;

/**
 * @ORM\Entity(repositoryClass=InformationPopupRepository::class)
 */
class InformationPopup
{
    /**
     * @var \Ramsey\Uuid\UuidInterface
     *
     * @ORM\Id
     * @ORM\Column(type="uuid", unique=true)
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class=UuidGenerator::class)
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $title;

    /**
     * @ORM\Column(type="text")
     */
    private $content;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $validationButtonText;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $closingButtonText;

    /**
     * Don't use EnablableEntityTrait as it is true by default.
     * Only one InformationPopup should be active at a time.
     * 
     * @ORM\Column(type="boolean", options={"default": false})
     */
    private $enabled = false;

    /**
     * @ORM\OneToMany(targetEntity=InformationPopupUser::class, mappedBy="informationPopup", orphanRemoval=true)
     */
    private $informationPopupUsers;

    public function __construct()
    {
        $this->informationPopupUsers = new ArrayCollection();
    }

    public function __toString(): string
    {
        return $this->getTitle();
    }

    public function getId()
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }

    public function setContent(string $content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getValidationButtonText(): ?string
    {
        return $this->validationButtonText;
    }

    public function setValidationButtonText(string $validationButtonText): self
    {
        $this->validationButtonText = $validationButtonText;

        return $this;
    }

    public function getClosingButtonText(): ?string
    {
        return $this->closingButtonText;
    }

    public function setClosingButtonText(string $closingButtonText): self
    {
        $this->closingButtonText = $closingButtonText;

        return $this;
    }

    public function getEnabled(): ?bool
    {
        return $this->enabled;
    }

    public function setEnabled(bool $enabled): self
    {
        $this->enabled = $enabled;

        return $this;
    }

    /**
     * @return Collection<int, InformationPopupUser>
     */
    public function getInformationPopupUsers(): Collection
    {
        return $this->informationPopupUsers;
    }

    public function addInformationPopupUser(InformationPopupUser $informationPopupUser): self
    {
        if (!$this->informationPopupUsers->contains($informationPopupUser)) {
            $this->informationPopupUsers[] = $informationPopupUser;
            $informationPopupUser->setInformationPopup($this);
        }

        return $this;
    }

    public function removeInformationPopupUser(InformationPopupUser $informationPopupUser): self
    {
        if ($this->informationPopupUsers->removeElement($informationPopupUser)) {
            // set the owning side to null (unless already changed)
            if ($informationPopupUser->getInformationPopup() === $this) {
                $informationPopupUser->setInformationPopup(null);
            }
        }

        return $this;
    }
}
