<?php

namespace App\Entity;

use App\Repository\CaissierRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=CaissierRepository::class)
 */
class Caissier
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="caissiers")
     * @ORM\JoinColumn(nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity=Prestataire::class, inversedBy="caissiers")
     * @ORM\JoinColumn(nullable=false)
     */
    private $prestataire;

    /**
     * Caissiers can export all the transactions since the last export.
     * 
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $lastTransactionsExportDatetime;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getPrestataire(): ?Prestataire
    {
        return $this->prestataire;
    }

    public function setPrestataire(?Prestataire $prestataire): self
    {
        $this->prestataire = $prestataire;

        return $this;
    }

    public function getLastTransactionsExportDatetime(): ?\DateTimeInterface
    {
        return $this->lastTransactionsExportDatetime;
    }

    public function setLastTransactionsExportDatetime(?\DateTimeInterface $lastTransactionsExportDatetime): self
    {
        $this->lastTransactionsExportDatetime = $lastTransactionsExportDatetime;

        return $this;
    }

    public function __toString()
    {
        return $this->getUser()->__toString();
    }
}
