<?php

namespace App\Tests;

use App\Entity\User;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\BrowserKit\Cookie;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;

class ApplicationAvailabilityFunctionalTest extends WebTestCase
{
    /**
     * @dataProvider urlProvider
     */
    public function testPageIsSuccessful($url)
    {
        $client = static::createClient([]);
        $client->request('GET', $url);

        self::assertEquals(Response::HTTP_OK, $client->getResponse()->getStatusCode());
    }

    public function urlProvider()
    {
        yield ['/'];
        yield ['/adherer'];
        yield ['/news'];
        yield ['/faq'];
        yield ['/contact'];
        yield ['/login'];
        yield ['/prestataires/liste'];
        yield ['/prestataires/carte'];
        yield ['/prestataires/rubriques'];
        yield ['/partenaires/liste'];
        yield ['/comptoirs/liste'];
        yield ['/comptoirs/carte'];
        yield ['/groupe/prestataires/amap/carte'];
        yield ['/groupe/prestataires/marche/carte'];
        yield ['/resetting/request'];
    }

    protected function createAuthorizedClient()
    {
        $client = static::createClient([]);
        $session = self::$container->get('session');
        $person = self::$container->get('doctrine.orm.entity_manager')->getRepository(User::class)->findOneByEmail('julien.jorry@gmail.com');

        $token = new UsernamePasswordToken($person, null, 'main', $person->getRoles());
        $session->set('_security_mlc_context', serialize($token));
        $session->save();

        $cookie = new Cookie($session->getName(), $session->getId());
        $client->getCookieJar()->set($cookie);

        return $client;
    }

    /**
     * @dataProvider adminUrlProvider
     */
    public function testAdminPageIsSuccessful($url)
    {
        $client = $this->createAuthorizedClient();

        $client->request('GET', $url);

        self::assertEquals(Response::HTTP_OK, $client->getResponse()->getStatusCode());
    }

    public function adminUrlProvider()
    {
        yield ['/'];
        yield ['/admin/dashboard'];
        yield ['/admin/app/user/list'];
        yield ['/admin/app/user/create'];
        yield ['/admin/app/usergroup/list'];
        yield ['/admin/adherent/list'];
        yield ['/admin/adherent/create'];
        yield ['/admin/cotisation_adherent/list'];
        yield ['/admin/prestataire/list'];
        yield ['/admin/prestataire/create'];
        yield ['/admin/cotisation_prestataire/list'];
        yield ['/admin/cotisation_prestataire/create'];
        // yield ['/admin/prestataire/1/edit'];
        // yield ['/admin/app/user/1/edit'];
        // yield ['/admin/adherent/1/edit'];
        // yield ['/admin/app/user/2/edit'];
        yield ['/admin/app/groupeprestataire/list'];
        yield ['/admin/app/groupeprestataire/create'];
        yield ['/admin/app/groupe/list'];
        yield ['/admin/app/groupe/create'];
        yield ['/admin/comptoir/list'];
        yield ['/admin/comptoir/create'];
        yield ['/admin/app/news/list'];
        yield ['/admin/app/news/create'];
        yield ['/admin/document/list'];
        yield ['/admin/document/create'];
        yield ['/admin/app/page/list'];
        yield ['/admin/app/page/create'];
        yield ['/admin/app/rubrique/list'];
        yield ['/admin/app/rubrique/create'];
        yield ['/admin/app/faq/list'];
        yield ['/admin/app/faq/create'];
        yield ['/admin/translations/list'];
        yield ['/admin/app/flux/list'];
        yield ['/admin/cotisation/list'];
        yield ['/admin/cotisation/create'];
        yield ['/admin/app/transfert/list'];
        yield ['/admin/app/transaction/list'];
        yield ['/admin/app/reconversion/list'];
        yield ['/admin/sonata/menu/list'];
        yield ['/admin/sonata/menu/create'];
        yield ['/admin/achat_monnaie/list'];
        yield ['/admin/demande_achat_monnaie/list'];
        yield ['/admin/app/operationadherent/list'];
        yield ['/admin/app/operationprestataire/list'];
        yield ['/admin/app/operationgroupe/list'];
        yield ['/admin/app/operationcomptoir/list'];
        yield ['/admin/app/operationsiege/list'];
    }
}
