<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotNull;

/**
 * Identification questionnaire for prestataire.
 */
class InfosPrestaQuizType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('userFirstName', TextType::class, [
                'mapped' => false, //store it into the user
                'label' => 'Prénom',
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('userLastName', TextType::class, [
                'mapped' => false, //store it into the user
                'label' => 'Nom',
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('raison', TextType::class, [
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('responsable', TextType::class, [
                'required' => true,
                'constraints' => [new NotNull()],
                'label' => 'Nom du responsable'
            ])
            ->add('metier', TextType::class, [
                'label' => 'Fonction du responsable',
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('horaires', TextType::class, [
                'label' => "Jours et horaires d'ouverture :",
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('geolocs', CollectionType::class, [
                'entry_type' => GeolocPrestataireFormType::class,
                'entry_options' => ['label' => false, 'with_latlon' => false],
                'required' => true,
                'allow_add' => false,
                'allow_delete' => false,
                'by_reference' => false,
                'label' => false,
            ])
            ->add('marketchannelfunction', ChoiceType::class, [
                'label' => 'Fonction dans le circuit de distribution',
                'choices' => [
                    'Distributeur/distributrice' => Prestataire::DISTRIBUTOR,
                    'Producteur/productrice' => Prestataire::PRODUCER,
                ],
                'required' => true,
                'constraints' => [new NotNull()],
            ])
            ->add('save', SubmitType::class, ['label' => 'Envoyer'])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Prestataire::class,
        ]);
    }

    public function getBlockPrefix(): string
    {
        return 'formInfosPrestaQuiz';
    }
}
