<?php

namespace App\Form\Type;

use App\Entity\DependentChild;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;


class DependentChildFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('olderThanFourteen', ChoiceType::class, array(
                'choices' => [
                    'oui' => true,
                    'non' => false
                ],
                'label' => "A-t-il plus de 14 ans ?",
                'required' => true,
                'expanded' => true
            ))
            ->add('sharedCustodyPercentage', ChoiceType::class, [
                'label' => "Est-il en garde partagée ?",
                'required' => true,
                'choices' => [
                    'non' => null,
                    'oui : je le garde 25 % du temps' => '0.25',//using strings as values (and not floats) seems required
                    'oui : je le garde 50 % du temps' => '0.50',//to make display work fine
                    'oui : je le garde 75 % du temps' => '0.75',
                ],
                'required' => false,
                'attr' => ['autocomplete' => 'off'] //avoid non-saved value to be displayed
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => DependentChild::class,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formDependentChild';
    }
}
