<?php

namespace App\Form\Type;

use Gregwar\CaptchaBundle\Type\CaptchaType;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class ContactFormType extends AbstractType
{
    protected $container;

    public function __construct(
        ContainerInterface $container
    ) {
        $this->container = $container;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom', TextType::class, [
                'label' => 'Votre nom :',
                'required' => true,
            ])
            ->add('email', EmailType::class, [
                'label' => 'Votre email :',
                'required' => true,
            ])
            ->add('message', TextareaType::class, [
                'label' => 'Votre message :',
                'required' => true,
            ])
            ->add('captcha', CaptchaType::class)
            ->add('save', SubmitType::class, ['label' => 'Envoyer'])
        ;
        if ($this->container->getParameter('tav_env') && $this->container->getParameter('presta_self_init_and_eval')) {
            $builder
                ->add('type', ChoiceType::class, [
                    'choices' => [
                        'Point de vente candidat' => 'prestataire_candidate',
                        'Adhérent' => 'adherent',
                        'Autre' => 'other',
                    ],
                    'label' => 'Vous êtes :',
                    'required' => true,
                ]);
        }
    }

    public function getBlockPrefix()
    {
        return 'formContact';
    }
}
