<?php

namespace App\Entity;

use App\Repository\PrestataireProductFamilyRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass=DependentChildRepository::class)
 * @ORM\Table(name="dependent_child")
 */
class DependentChild
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=Adherent::class, inversedBy="adherentDependentChildren")
     * @ORM\JoinColumn(nullable=false)
     */
    private $adherent;

    /**
     * @ORM\Column(type="boolean")
     */
    private $olderThanFourteen;

    /**
     * @var float
     *
     * @ORM\Column(name="sharedcustodypercentage", type="decimal", scale=2, nullable=true)
     * @Assert\Type("numeric")
     */
    protected $sharedCustodyPercentage;


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAdherent(): ?Adherent
    {
        return $this->adherent;
    }

    public function setAdherent(?Adherent $adherent): self
    {
        $this->adherent = $adherent;

        return $this;
    }

    public function getOlderThanFourteen()
    {
        return $this->olderThanFourteen;
    }

    public function setOlderThanFourteen($olderThanFourteen)
    {
        $this->olderThanFourteen = $olderThanFourteen;

        return $this;
    }
    
    public function getSharedCustodyPercentage()
    {
        return $this->sharedCustodyPercentage;
    }

    public function setSharedCustodyPercentage($sharedCustodyPercentage)
    {
        $this->sharedCustodyPercentage = $sharedCustodyPercentage;

        return $this;
    }
}
