<?php

namespace App\Entity;

use App\Enum\CurrencyEnum;
use App\Utils\OperationFactory;
use Doctrine\ORM\Mapping as ORM;

/**
 * Application du calcul de l'allocation (emlc reçues) lors du paiement d'une cotisation (au sens TAV).
 * 
 * Au paiement d'une cotisation:
 *      - Un premier Flux est enregistré, correspondant à l'achat/vente d'emlc.
 *      - On crée un nouveau flux pour compléter la cotisation, en fonction du système de calcul choisi.
 * 
 * Systèmes de calculs possibles :
 *      - On applique le taux défini dans le ProfilDeCotisation de l'adhérent
 *      - On calcule le montant à recevoir en fonction du foyer de l'adhérent
 *
 * @ORM\Entity
 */
class CotisationTavApplication extends Flux
{
    const TYPE_REVERSEMENT_COTISATION_ADHERENT = 'reversement_cotisation_adherent';
    const TYPE_PRELEVEMENT_COTISATION_ADHERENT = 'prelevement_cotisation_adherent';
    const TYPE_PRELEVEMENT_COTISATION_ADHERENT_DEPASSEMENT_PLAFOND = 'prelevement_cotisation_adherent_depassement_plafond';
    const TYPE_PRELEVEMENT_COTISATION_ADHERENT_CORRECTION_SOLDE = 'prelevement_cotisation_adherent_correction_solde';
    const TYPE_REVERSEMENT_COTISATION_ADHERENT_CORRECTION_SOLDE = 'reversement_cotisation_adherent_correction_solde';

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return parent::TYPE_APPLICATION_COTISATION_TAV;
    }

    public function getAllOperations($em)
    {
        return [];
    }

    public function operate($em)
    {
        return [];
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return '';
    }

    public function getUsersToNotify()
    {
        return [];
    }
}
