<?php

namespace App\Admin;

use App\Application\Sonata\UserBundle\Admin\UserAdmin as SonataUserAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;

/**
 * Administration des utilisateurs.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class UserAdmin extends SonataUserAdmin
{
    protected $baseRouteName = 'user';
    protected $baseRoutePattern = 'user';

    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'updatedAt',
        // '_page' => 1,
        // '_per_page' => 32
    ];

    public function configure()
    {
        parent::configure();
        // $this->classnameLabel = "Utilisateurs";
    }

    /**
     * {@inheritdoc}
     */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        parent::configureFormFields($formMapper);

        $user = $this->getSubject();
    }

    /**
     * {@inheritdoc}
     */
    protected function configureListFields(ListMapper $listMapper): void
    {
        parent::configureListFields($listMapper);
        unset($this->listModes['mosaic']);

        // TODO: SECURITY BREACH, RESET ASAP!!!
        // if ('dev' == $_ENV['APP_ENV'] && $this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
        if ($this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
            $listMapper
                ->add('impersonating', 'string', ['template' => '@SonataUser/Admin/Field/impersonating.html.twig'])
            ;
        }
        // $listMapper
            // ->addIdentifier('username', null, array('label' => 'Username'))
            // ->addIdentifier('email', null, array('label' => 'Email'));
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        if ($this->isChild()) {
            $collection->remove('delete');

            return;
        }

        // This is the route configuration as a parent
        $collection->clear();
    }

    /**
     * {@inheritdoc}
     */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('email', null, [
                'label' => 'Email',
                'advanced_filter' => false,
            ])
            ->add('enabled', null, [
                'label' => 'Activé ?',
                'advanced_filter' => false,
            ])
        ;
    }

    /*
    * {@inheritdoc}
    */
    // protected function configureRoutes(RouteCollection $collection)
    // {
    //     // $collection->remove('create');
    //     // if (!$this->isGranted('ROLE_SUPER_ADMIN')) {
    //     //     $collection->clearExcept([]);
    //     // }
    //     if ($this->isChild()) {
    //         return;
    //     }

    //     // This is the route configuration as a parent
    //     // $collection->clear();
    // }
}
