# Installation de Kohinos

**PROCEDURE D'INSTALLATION EN PRODUCTION :**

## Environnement requis

Apache >= 2

PHP = 7.4

Extensions PHP :

    intl
    ctype
    iconv
    mariadb (ou mysql > 8.0)
    gd
    bcmath (en environnement tav/ssa)

Installer composer si besoin

$ curl -sS https://getcomposer.org/installer | php

## Cloner le projet dans le dossier nomdudossier

    Sur o2switch, l'accès au clone via SSH est impossible, utilisez plutôt le mode HTTP !

SSH : **$ git clone git@gitlab.com:federation-kohinos/kohinos.git nomdudossier**

ou

HTTPS : $ git clone https://gitlab.com/federation-kohinos/kohinos.git nomdudossier

=> Taper login et mot de passe GITLAB

Aller à nomdudossier

$ cd nomdudossier

## Installer l'environnement du projet

Modifier les variables d'environnement

Copier le fichier .env.dist en .env et configurer :

    l'accès à la base de données (DATABASE_URL)

    bien faire attention à copier la Version du serveur Mysql (visible sur la page d'accueil de phpmyadmin "Version du serveur :" 
    (toute la valeur avant ' - ') à la fin de la variable DATABASE_URL après "?serverVersion=". 
    Exemple : Sur Mysql on a : Version du serveur : 10.3.31-MariaDB - MariaDB Server 
    On ajoute à DATABASE_URL : => ?serverVersion=10.3.31-MariaDB

- APP_ENV=dev et APP_DEBUG=1
- l'envoi de mail (MAILER_URL (penser à saisir MLC_NOTIF_EMAIL compatible avec le MAILER utilisé))
- la variable APP_SECRET (variable secrète que vous pouvez générer à partir de cette url : http://nux.net/secret
- s'il s'agit d'une instance TAV, mettre la variable TAV_ENV à 1 (sinon la laisser à zéro)
- en environnement TAV, pour activer le parcours d'inscription autonomisé qui intègre la réponse à une questionnaire d'auto-évaluation pour les points de vente, passer PRESTA_SELF_INIT_AND_EVAL à 1
- en environnement TAV, la variable AUTOMATISATION_RECONVERSION permet d'activer l'automatisation des reconversions
- en environnement TAV, la variable PRESTA_EXTRA_DATA permet d'indiquer puis d'afficher publiquement plus de données concernant les prestataires (e.g. familles de produits) 
- en environnement TAV, la variable HOUSEHOLD_BASED_ALLOWANCE permet d'activer un mode de cotisation libre (avec valeur minimum) et d'allocations basées sur la composition du foyer. Active également la possibilité pour l'admin de renseigner un quartier ainsi qu'un territoire à une fiche adhérent, rajoute l'information "Solde & plafond" dans la liste des adhérents (plafond défini à 2x le montant de l'allocation), ainsi que la possibilité de corriger le solde d'un adhérent.
- en environnement TAV, la variable SIMPLIFIED_HOUSEHOLD_BASED_ALLOWANCE permet d'activer un mode simplifié d'allocation en fonction de la composition du foyer (pas de minimum de cotisation, moins de détails dans la composition du foyer de l'adhérent, pas de renseignement de territoire dans la fiche adhérent, calcul de l'allocation simplifié, pas de plafond de solde). /!\ Requiert l'activation de HOUSEHOLD_BASED_ALLOWANCE.
- en environnement TAV, la variable SSA_FRIENDLY_FLUX_TYPE_NAMES permet d'adapter le nommage des types de flux et les écrans de visualisation des flux à un projet de type SSA
- en environnement TAV, la varialble CCAS_MODE permet d'activer les fonctionnalités de branchement avec une CCAS. Attention : Pour activer CCAS_MODE, le paramètre AUTOMATISATION_RECONVERSION doit OBLIGATOIREMENT être activé.

Si vous utilisez Payzen comme moyen de paiement par CB :

1. - PAYZEN_SITE_ID=VotreConfigPayzen
2. - PAYZEN_CERTIFICATE=VotreConfigPayzen
3. - PAYZEN_CTX_MODE=TEST
4. - PAYZEN_DEBUG=true

## Installer les dépendances via composer

$ php ../composer.phar install --optimize-autoloader

ou

**$ composer install --optimize-autoloader**

## S'assurer des droits d'accès

Certains dossiers doivent être accessibles en écriture par le kohinos pour le bon fonctionnement de l'application.

Par exemple, pour le dossier ccastransactions, lancer les commandes suivantes :

**chown www-data:kohinos ccastransactions** (ou groupe:utilisateur appropriés)

**chmod 775 ccastransactions**

## Lancer la création de la base de données et des données de base du kohinos

Création de la base de données, si ce n'est déjà fait avec les accès dans le .ENV :

**$ php bin/console doctrine:database:create**

Création des tables et des contraintes :

**$ php bin/console doctrine:migrations:migrate --no-interaction**

Charger les fixtures standards :

Pour une instance non SSA :  
**$ php bin/console hautelook:fixtures:load --purge-with-truncate --env=pro**  
Pour une instance TAV, ou bien :  
**$ php bin/console hautelook:fixtures:load --purge-with-truncate --env=tavpro**  
ou bien :  
**$ php bin/console hautelook:fixtures:load --purge-with-truncate --env=ssagirondepro**

Vous obtiendrez cette erreur ci dessous, c'est normal !

In MediaEventSubscriber.php line 96:
There is no main category related to context: rubrique

**$ php bin/console sonata:media:fix-media-context**

Pour une instance non SSA :  
**$ php bin/console hautelook:fixtures:load --append --env=pro**  
Pour une instance TAV, ou bien :  
**$ php bin/console hautelook:fixtures:load --append --env=tavpro**  
ou bien :    
**$ php bin/console hautelook:fixtures:load --append --env=ssagirondepro**


Supprimer le cache (si besoin)

**$ php bin/console cache:clear**

ou

`$ rm -rf var/cache/*`
(supprimes tous les dossiers de cache, plus rapide que clear:cache et plus efficace en cas de changement de structure de base de données)

##Installer les assets

**$ php bin/console assets:install**
 
## Générer les fichiers et la BDD des traductions (pour pouvoir les modifier via l'interface d'administration notamment)

!!! NE FONCTIONNE PLUS POUR LE MOMENT !!!

$ php bin/console translation:update --force fr --prefix=""

$ php bin/console translation:update --force en --prefix=""

$ php bin/console lexik:translations:import --case-insensitive --force -c


Si besoin, modifier le htaccess (si apache < 2.4, il y a le .htaccessOLD qui peut être comptatible) (pas nécessaire sur o2switch)

$ vi .htaccess

INSTALLATION SUR LE SERVEUR TERMINÉE

## Mettre à jour le logo et favicon
Une fois tout installé, éventuellement changer le logo et favicon situés dans :
- `public/images/favicon/` pour le favicon
- `public/images/logo.png/` pour le logo

## Configuration & test du Paiement Payzen

Une fois Payzen configuré sur le Kohinos, il faut le configurer sur le Back Office de Payzen :

    Paramétrage -> Boutique : configurer les 2 "URL de retour de la boutique" avec la page d'accueil du site.
    Paramétrage -> Règles de notification -> URL de notification à la fin du paiement : dans le 2ème encadré, renseigner les 2 champs avec [url_du_site]/payment/notify
    Paramétrage -> Règles de notification -> URL de notification à la création d'un abonnement (mal nommé à mon avis car utilisé à chaque échéance) : dans le 2ème encadré, renseigner les 2 champs avec [url_du_site]/payment/notify
    Remarque : les URLS de notification sont réécrites par Payum à la même valeur dans le cadre de sa configuration par défaut 

Une fois l'installation et la configuration du Kohinos terminées, il est conseillé de réaliser un premier paiement afin de tester le bon fonctionnement de la communication avec Payzen en environnement de production.

Pour cela, payez une cotisation par exemple que vous pourrez rembourser dans le Back Office de Payzen et invalider dans l'admin du Kohinos (reçu = false).

## CONFIGURATION DU KOHINOS POUR VOTRE MONNAIE LOCALE

Naviguer vers l'url de votre installation du Kohinos et vous accéderez à l'écran d'installation et de configuration du nom de la monnaie, du super admin, email et mot de passe, ainsi que le nom du siège, du premier groupe local, du solde de monnaie du siège, du centre de la carte etc...

EN CAS D'ERREUR 500 :

- Vérifier les logs présents dans var/log/, en général, si l'environnement est PROD, on peut aller voir le fichier prod.critical-DATE-DU-JOUR.log
Pour cela on peut utiliser la commande suivante : 
**tail -f var/log/prod.xxx.log | grep CRITICAL**

## Mettre en place les CRON jobs

Ecrire dans un fichier tav dans /etc/cron.d :

Quand TAV_ENV = 1, pour envoyer les rappels de cotisation :

    42      0       *       *       *       kohinos php /home/kohinos/kohinos/bin/console kohinos:tav:mail-rappel-cotisation

Quand AUTOMATISATION_RECONVERSION = 1, pour que les reconversions aient lieu les dimanches soir qui précèdent les 14 et/ou 28 :

    15      23      *       *       0       kohinos [ "$(date +\%d)" -ge 08 -a "$(date +\%d)" -le 14 ] && php /home/kohinos/kohinos/bin/console kohinos:ssa:reconversion-prestataires twice_a_month
    15      23      *       *       0       kohinos [ "$(date +\%d)" -ge 22 -a "$(date +\%d)" -le 28 ] && php /home/kohinos/kohinos/bin/console kohinos:ssa:reconversion-prestataires twice_a_month
    17      23      *       *       0       kohinos [ "$(date +\%d)" -ge 22 -a "$(date +\%d)" -le 28 ] && php /home/kohinos/kohinos/bin/console kohinos:ssa:reconversion-prestataires once_a_month
    19      23      *       1,3,5,7,9,11    0        kohinos [ "$(date +\%d)" -ge 22 -a "$(date +\%d)" -le 28 ] && php /home/kohinos/kohinos/bin/console kohinos:ssa:reconversion-prestataires once_every_two_month

Quand CCAS_MODE = 1, pour que les reconversions CCAS soient effectuées et les exports envoyés le 1 du mois puis effacés du disque le 10 du mois :

    47      1       1       *       *       kohinos php /home/kohinos/kohinos/bin/console kohinos:ssa:reconversion-ccas-prestataires
    57      1       1       *       *       kohinos php /home/kohinos/kohinos/bin/console kohinos:ssa:export-ccas-transactions
    27      2       10       *       *       kohinos rm -f /home/kohinos/kohinos/ccastransactions/*

## Lancer le Kohinos en local

Installer le client symfony

Permettre la simulation du https en local :

**$ symfony server:ca:install**

Lancer le serveur local

**$ symfony server:start**


Compiler les assets (css & js) après modification pour tests

**$ yarn install** si besoin (première modif des assets)

**$ yarn run encore dev**

Compiler les assets avant de commit : 
**$ yarn run encore prod**
