<?php

namespace App\Form\Type;

use App\Entity\ExternalAdherentDatedData;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityManagerInterface;


class ExternalAdherentDatedDataFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('year', NumberType::class, [
                'label' => 'Année',
                'required' => true,
                'attr' => [
                    'autocomplete' => 'off'
                ],
            ])
            ->add('annual_income', NumberType::class, [
                'label' => 'Revenu annuel',
                'required' => false,
                'attr' => [
                    'autocomplete' => 'off'
                ],
            ])
            ->add('monthly_income', NumberType::class, [
                'label' => 'Revenu mensuel',
                'required' => false,
                'attr' => [
                    'autocomplete' => 'off'
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ExternalAdherentDatedData::class,
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formExternalAdherentDatedData';
    }
}
