<?php

namespace App\Entity;

use App\Enum\CurrencyEnum;
use App\Utils\OperationFactory;
use Doctrine\ORM\Mapping as ORM;

/**
 * Dans les cas suivants :
 * - [Profil de Cotisation] La taux est inférieur à 1 
 * - [Allocation selon foyer] Le montant reçu calculé est inférieur au montant payé
 * - [Allocation selon foyer] Un administrateur effectue une opération manuelle de prélèvement de l'adhérent
 *   pour ramener son solde au niveau de son plafond.
 * - [Allocation selon foyer] Un administrateur effectue une opération de correction de solde qui conduit à un prélèvement.
 * 
 * L'adhérent•e reçoit moins d'emlc que ce qu'elle•il paye en €, 
 * un second flux est créé pour prélever le complément de la cotisation.
 *
 * @ORM\Entity
 */
class CotisationTavPrelevement extends CotisationTavApplication
{
    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Siege")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id")
     */
    protected $destinataire;

    public function getAllOperations($em)
    {
        return [
            OperationFactory::getOperation($this, $this->getExpediteur(), CurrencyEnum::CURRENCY_EMLC, -$this->getMontant()),
            OperationFactory::getOperation($this, $this->getDestinataire(), CurrencyEnum::CURRENCY_EMLC, -$this->getMontant()),  // Decrease siege ecompte too
        ];
    }

    public function operate($em)
    {
        $this->getDestinataire()->removeEcompteNantie($this->getMontant());
        $this->getExpediteur()->removeEcompte($this->getMontant());

        return [$this->getExpediteur(), $this->getDestinataire()];
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return parent::TYPE_PRELEVEMENT_COTISATION_ADHERENT;
    }

    public function getUsersToNotify()
    {
        return [];
    }
}
