<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Security\Core\Security;
use App\Entity\Adherent;

/**
 * Administration des tiers financeurs.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 */
class ThirdPartyFinancerAdmin extends AbstractAdmin
{
    protected $security;

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    protected function configureFormFields(FormMapper $form): void
    {
        $thirdPartyFinancer = $this->getSubject();
        $form
            ->with('Tiers Financeur', ['class' => 'col-md-12'])
                ->add('name', TextType::class, [
                    'label' => 'Nom :',
                    'required' => true,
                ])
                ->add('fundingAmount', NumberType::class, [
                    'label' => 'Montant de prise en charge :',
                    'required' => true,
                ])
                ->add('supportedAdherents', EntityType::class, [
                    'class' => Adherent::class,
                    'multiple' => true,
                    'required' => false,
                    'by_reference' => false,
                    'choices' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Adherent::class)->findbyNoThirdPartyFinancer($thirdPartyFinancer->getId()),
                    'label' => 'Adhérents soutenus :',
                    'help' => 'Vous pouvez sélectionner les adhérents qui ne sont pas déjà soutenu par un tiers financeur'
                ])
            ->end()
        ;
    }

    protected function configureDatagridFilters(DatagridMapper $datagrid): void
    {
        $datagrid->add('name', null, [
            'label' => 'Nom'
        ]);
    }

    protected function configureListFields(ListMapper $list): void
    {
        $list
            ->addIdentifier('name', null, [
                'label' => 'Nom'
            ])
            ->addIdentifier('fundingAmount', null, [
                'label' => 'Montant de prise en charge'
            ])
        ;
    }
}