<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use App\Entity\SelfEvalPrestaQuiz;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ProducerSelfEvalPrestaQuizType extends SelfEvalPrestaQuizType
{
    public function __construct(Security $security, array $options = [])
    {
        parent::__construct($security, $options);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);


        /* PARTIE 4 : PRATIQUES AGRICOLES DURABLES */
        $this->opts['label'] = "Détenez-vous des labels ou des certifications (AB Bio, Nature et Progrès, système de garantie participatif ou équivalent minimum) ?";
        $this->opts['choices'] = [
            $this->frown . " non" => 0,
            $this->smile . " oui" => 2,
        ];
        $builder->add('proagdur_labels', ChoiceType::class, $this->opts);
        $builder->add('proagdur_labels_comment', TextareaType::class, $this->cmtOpts);

        //Jusqu'à la fin
        $this->opts['choices'] = $this->stdChoices;

        $this->opts['label'] = "Les pratiques agricoles permettent-elles de valoriser la biodiversité ?";
        $builder->add('proagdur_valbio', ChoiceType::class, $this->opts);
        $builder->add('proagdur_valbio_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les pratiques agricoles permettent-elles l'économie ou le recyclage de l'énergie, de l'eau, de la matière organique, des nutriments ?";
        $builder->add('proagdur_ecorec', ChoiceType::class, $this->opts);
        $builder->add('proagdur_ecorec_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les pratiques agricoles réduisent-elles les pertes agricoles (au champ ou post-récolte) ?";
        $builder->add('proagdur_pertes', ChoiceType::class, $this->opts);
        $builder->add('proagdur_pertes_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les pratiques agricoles contribuent-elles à l'atténuation ou à l'adaptation au changement climatique ?";
        $builder->add('proagdur_climat', ChoiceType::class, $this->opts);
        $builder->add('proagdur_climat_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les pratiques agricoles permettent-elles de renforcer l'autonomie de la ferme en ressources génétiques (végétales ou animales), en eau, en intrants, en énergie ?";
        $builder->add('proagdur_geneti', ChoiceType::class, $this->opts);
        $builder->add('proagdur_geneti_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Les pratiques agricoles permettent-elles la protection des sols ?";
        $builder->add('proagdur_prosol', ChoiceType::class, $this->opts);
        $builder->add('proagdur_prosol_comment', TextareaType::class, $this->cmtOpts);
        $this->opts['label'] = "Pratiques agricoles durables : " . $this->labelEvalGlob . " (cochez vert si vous détenez un label ou une certification)";
        $this->opts['choices'] = $this->stdGlobalChoices;
        $builder->add('proagdur_global', ChoiceType::class, $this->opts);
        $builder->add('proagdur_global_comment', TextareaType::class, $this->globalCmtOpts);
        
        //Review
        if($options['mode'] !== self::PRESTA_EDIT) {
            $this->reviewOpts['label'] = "Pratiques agricoles durables : " . $this->reviewLabel;
            $this->reviewOpts['choices'] = $this->stdGlobalChoices;
            $builder->add('review_proagdur_global', ChoiceType::class, $this->reviewOpts);
            $builder->add('review_proagdur_global_comment', TextareaType::class, $this->reviewCmtOpts);
        }
    }

    public function getBlockPrefix(): string
    {
        return 'formProducerSelfEvalPrestaQuiz';
    }
}
