<?php

namespace App\Entity;

use App\Repository\InformationPopupUserRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=InformationPopupUserRepository::class)
 */
class InformationPopupUser
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=InformationPopup::class, inversedBy="informationPopupUsers")
     * @ORM\JoinColumn(nullable=false)
     */
    private $informationPopup;

    /**
     * @ORM\ManyToOne(targetEntity=User::class)
     * @ORM\JoinColumn(nullable=false)
     */
    private $user;

    /**
     * @ORM\Column(type="boolean", options={"default": false})
     */
    private $hasValidated = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInformationPopup(): ?InformationPopup
    {
        return $this->informationPopup;
    }

    public function setInformationPopup(?InformationPopup $informationPopup): self
    {
        $this->informationPopup = $informationPopup;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getHasValidated(): ?bool
    {
        return $this->hasValidated;
    }

    public function setHasValidated(bool $hasValidated): self
    {
        $this->hasValidated = $hasValidated;

        return $this;
    }
}
