<?php

namespace App\Admin;

use App\Entity\AccountAdherent;
use App\Entity\Adherent;
use App\Entity\OperationAdherent;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;

/**
 * Administration des operation des prestataires.
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class OperationAdherentAdmin extends OperationAdmin
{
    protected function configureListFields(ListMapper $listMapper)
    {
        $listMapper->add('account.accountableObject', null, ['label' => 'Compte adherent', 'template' => '@kohinos/bundles/SonataAdminBundle/Block/accountable.html.twig']);
        parent::configureListFields($listMapper);
    }

    /**
     * {@inheritdoc}
     */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();
        $operationAdherenttable = $em->getMetadataFactory()->getMetadataFor(OperationAdherent::class)->getTableName();

        if ($user && ($this->security->isGranted('ROLE_GESTION_GROUPE') || $this->security->isGranted('ROLE_CONTACT') || $this->security->isGranted('ROLE_TRESORIER'))) {
            if ($this->hasRequest()) {
                if (empty($this->getRequest()->getSession()->get('_groupegere'))) {
                    if (!$this->security->isGranted('ROLE_TRESORIER')) {
                        $query->andWhere('false = true');
                    }
                } else {
                    $groupe = $this->getRequest()->getSession()->get('_groupegere');
                    $connection = $em->getConnection();
                    $adherentTable = $em->getMetadataFactory()->getMetadataFor(Adherent::class)->getTableName();
                    $accountTable = $em->getMetadataFactory()->getMetadataFor(AccountAdherent::class)->getTableName();
                    $statement = $connection->prepare('SELECT f.id FROM ' . $operationAdherenttable . ' f WHERE f.account_id IN  
                        (SELECT a.id FROM ' . $accountTable . ' a WHERE a.adherent_id IN 
                            (SELECT p.id FROM ' . $adherentTable . ' p WHERE p.groupe_id = "' . $groupe->getId() . '")
                        )');
                    $statement->execute();
                    $ids = $statement->fetchAll();
                    $query
                        ->andWhere($query->expr()->in($query->getRootAliases()[0] . '.id', ':ids'))
                        ->setParameter('ids', $ids)
                    ;
                }
            }
        }

        return $query;
    }

    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('account.adherent', null, [
                'label' => 'Adherent',
                'advanced_filter' => false,
                'show_filter' => true,
            ]);

        // In household based allowance (but not simplified) add filter on adherent territory
        $household_based_allowance = $this->getConfigurationPool()->getContainer()->getParameter('household_based_allowance');
        $simplified_household_based_allowance = $this->getConfigurationPool()->getContainer()->getParameter('simplified_household_based_allowance');

        if($household_based_allowance && !$simplified_household_based_allowance) {
            $datagridMapper->add('account.adherent.geoloc.subterritory', null, [
                'label' => 'Territoire',
                'advanced_filter' => false,
                'show_filter' => true,
            ]);
        }
    }
}
