<?php

namespace Ekyna\Component\Payum\Payzen\Action;

use Ekyna\Component\Payum\Payzen\Request\Request;
use Payum\Core\Action\ActionInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Payum\Core\GatewayAwareTrait;
use Payum\Core\Request\Capture;
use Payum\Core\Request\Sync;
use Payum\Core\Security\GenericTokenFactoryAwareInterface;
use Payum\Core\Security\GenericTokenFactoryAwareTrait;

/**
 * Class CaptureAction
 * @package Ekyna\Component\Payum\Payzen\Action
 * @author  Etienne Dauvergne <contact@ekyna.com>
 */
class CaptureAction implements ActionInterface, GatewayAwareInterface, GenericTokenFactoryAwareInterface
{
    use GatewayAwareTrait;
    use GenericTokenFactoryAwareTrait;

    /**
     * {@inheritdoc}
     *
     * @param Capture $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);

        $model = ArrayObject::ensureArrayObject($request->getModel());


        if ($request->getToken()) {
            // Done redirections
            $targetUrl = $request->getToken()->getTargetUrl();
            $doneUrlFields = [
                'vads_url_cancel',   // Annuler et retourner à la boutique
                'vads_url_error',    // Erreur de traitement interne
                'vads_url_referral', // 02 contacter l'émetteur de la carte
                'vads_url_refused',  // Refus autre que 02
                'vads_url_success',  // 00 Success
                'vads_url_return',   // Retour à la boutique
            ];
            foreach ($doneUrlFields as $field) {
                if (false == $model[$field]) {
                    $model[$field] = $targetUrl;
                }
            }

            // Notify url
            if (empty($model['vads_url_check']) && $this->tokenFactory) {
                // Custom action
                $notifyToken = $this->tokenFactory->createNotifyToken(
                    $request->getToken()->getGatewayName(),
                    $request->getToken()->getDetails()
                );
                $model['vads_url_check'] = $notifyToken->getTargetUrl();
            }

            // Set recurrent payment data if needed
            $payment = $request->getFirstModel();
            if (true == $payment->getIsRecurrent()) {
                $model['vads_page_action'] = 'REGISTER_PAY_SUBSCRIBE';
                $model['vads_sub_amount'] = strval($payment->getRecurrenceAmount());  // 1000 for 10.00 EUR
                $model['vads_sub_currency'] = $model['vads_currency'];
                //Pour éviter les doublons de paiement, la date d'effet doit être ultérieure à recurrenceMonthDay.
                //Ce jour étant calculé du point de vue du fuseau horaire du serveur,
                //la date d'effet doit donc elle aussi être calculée dans le fuseau horaire du serveur, et non dans
                //le fuseau horaire UTC.
                $model['vads_sub_effect_date'] = (new \DateTime('tomorrow'))->format('Ymd');  // tomorrow, to avoid duplicate payment this day
                //FOR TEST : $model['vads_sub_desc'] = 'RRULE:FREQ=DAILY;INTERVAL=1;COUNT=2';

                $count = $payment->getRecurrenceMonthsCount() - 1; //initial payment is not considered by payzen as the first occurence
                $monthDay = $payment->getRecurrenceMonthDay();
                $model['vads_sub_desc'] = "RRULE:FREQ=MONTHLY;COUNT={$count};BYMONTHDAY={$monthDay}";
            }
        }

        if (false == $model['vads_trans_id']) {
            $this->gateway->execute(new Request($model));
        }

        $this->gateway->execute(new Sync($model));
    }

    /**
     * {@inheritdoc}
     */
    public function supports($request)
    {
        return $request instanceof Capture
            && $request->getModel() instanceof \ArrayAccess;
    }
}
