<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\DonAdherent;
use App\Entity\Prestataire;
use App\Entity\GlobalParameter;
use App\Enum\MoyenEnum;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\GreaterThanOrEqual;

class ComptoirEncaisserDonAdherentFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (empty($this->security) || empty($this->security->getUser())) {
            throw new \Exception('[FORM COMPTOIR ENCAISSEMENT DON ADHERENT] Opération impossible !');
        }

        $builder
            ->add('moyen', ChoiceType::class, [
                'required' => true,
                'choices' => $this->moyensUtils->getAvailableTypesComptoir(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
                'expanded' => true,
                'multiple' => false,
                'label' => 'Sélectionnez un moyen de paiement :',
            ])
            ->add('destinataire', HiddenType::class, [
                'data' => $this->em->getRepository(Prestataire::class)->findOneBy(['mlc' => true]),
                'data_class' => null,
                'entity_class' => Prestataire::class,
                'em' => $this->em,
            ])
            ->add('montant', MoneyType::class, [
                'data' => 0,
                'label' => $this->container->getParameter('tav_env') ? "Don à la caisse alimentaire :" : "Don à l'association :",
                'required' => false,
                'constraints' => [
                    new GreaterThanOrEqual(['value' => 0]),
                ],
                'attr' => ['autocomplete' => 'off']
            ])
            ->add('expediteur', EntityType::class, [
                'class' => Adherent::class,
                'choices' => $this->em->getRepository(Adherent::class)->findOrderByName(),
                'placeholder' => $this->container->getParameter('tav_env') ? 'Habitant' : 'Adherent',
                'required' => true,
                'label' => $this->container->getParameter('tav_env') ? 'Habitant :' : 'Adherent :'
            ])
            ->add('reference', HiddenType::class, [
                'data' => 'Don Adhérent'
            ])
            ->remove('save')
            ->add('save', SubmitType::class, [
                'label' => 'Valider',
                'attr' => [
//                    'class' => 'btn-primary btn fluxSubmit', with fluxSubmit class, required attributes does not prevent incorrect form to be submit
                    'class' => 'btn-primary',
                ],
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'class' => DonAdherent::class,
        ]);
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formComptoirEncaisserDonAdherent';
    }
}
