<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Doctrine\UuidGenerator;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ORM\Entity
 * @ORM\Table(name="selfevalprestaquiz")
 */
class SelfEvalPrestaQuiz
{
    /*
     * This class is really just about storing results of a form in a database.
     * Attributes are not going to be part of any logic code.
     * I opt to set all attributes public to save coding time.
     */

    /**
     * @var \Ramsey\Uuid\UuidInterface
     *
     * @ORM\Id
     * @ORM\Column(type="uuid", unique=true)
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class=UuidGenerator::class)
     * @Groups({"read"})
     */
    protected $id;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_geophy;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_tempor;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_edupop;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_divers;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_vulner;

    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_geophy_comment;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_tempor_comment;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_edupop_comment;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_divers_comment;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_vulner_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $bienetre_format;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $bienetre_format_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $bienetre_impgou;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $bienetre_impgou_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $bienetre_bienet;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $bienetre_bienet_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $bienetre_recben;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $bienetre_recben_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $transpar_jusrem;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $transpar_jusrem_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $transpar_transp;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $transpar_transp_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $transpar_relpro;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $transpar_relpro_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $disagdur_labels;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $disagdur_labels_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $disagdur_condur;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $disagdur_condur_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_labels;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_labels_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_valbio;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_valbio_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_ecorec;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_ecorec_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_pertes;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_pertes_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_climat;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_climat_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_geneti;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_geneti_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_prosol;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_prosol_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $localite_probru;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $localite_probru_comment;
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $localite_protra;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $localite_protra_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $accessib_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $accessib_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $bienetre_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $bienetre_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $transpar_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $transpar_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $disagdur_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $disagdur_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $proagdur_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $proagdur_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $localite_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $localite_global_comment;
    
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_accessib_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_accessib_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_bienetre_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_bienetre_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_transpar_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_transpar_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_disagdur_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_disagdur_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_proagdur_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_proagdur_global_comment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    public $review_localite_global;
    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    public $review_localite_global_comment;
    /**
     * As the form been fully submitted?
     * @var bool
     * @ORM\Column(type="boolean", nullable=false, options={"default" : false})
     */
    public $isSubmitted;
}
