<?php

namespace App\Entity;
use Doctrine\ORM\Mapping as ORM;

/**
 * Child class used to notify adherents by email.
 *
 * - [Allocation selon foyer] Un administrateur effectue une opération manuelle de prélèvement de l'adhérent
 *   pour ramener son solde au niveau de son plafond.
 * @ORM\Entity
 */
class CotisationTavPrelevementDepassementPlafond extends CotisationTavPrelevement
{
    /**
     * @return string
     */
    public function getType(): string
    {
        return parent::TYPE_PRELEVEMENT_COTISATION_ADHERENT_DEPASSEMENT_PLAFOND;
    }

    public function getUsersToNotify()
    {
        return [
            'expediteurs' => [$this->getExpediteur()->getUser()],
        ];
    }
}
