<?php

namespace App\Repository;

use App\Entity\ThirdPartyAllocationFunding;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<ThirdPartyAllocationFunding>
 *
 * @method ThirdPartyAllocationFunding|null find($id, $lockMode = null, $lockVersion = null)
 * @method ThirdPartyAllocationFunding|null findOneBy(array $criteria, array $orderBy = null)
 * @method ThirdPartyAllocationFunding[]    findAll()
 * @method ThirdPartyAllocationFunding[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ThirdPartyAllocationFundingRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ThirdPartyAllocationFunding::class);
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function add(ThirdPartyAllocationFunding $entity, bool $flush = true): void
    {
        $this->_em->persist($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function remove(ThirdPartyAllocationFunding $entity, bool $flush = true): void
    {
        $this->_em->remove($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    // /**
    //  * @return ThirdPartyAllocationFunding[] Returns an array of ThirdPartyAllocationFunding objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('t.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?ThirdPartyAllocationFunding
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
